// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Maps.Weather.Models
{
    /// <summary> The IntervalSummary. </summary>
    public partial class IntervalSummary
    {
        /// <summary> Initializes a new instance of <see cref="IntervalSummary"/>. </summary>
        internal IntervalSummary()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IntervalSummary"/>. </summary>
        /// <param name="startMinute"> The first minute to which the summary applies. </param>
        /// <param name="endMinute"> The last minute to which the summary applies. </param>
        /// <param name="totalMinutes"> The number of minutes for which the summary applies. </param>
        /// <param name="shortDescription"> Short summary phrase. Phrase length is approximately 25 characters. </param>
        /// <param name="briefDescription"> Brief summary phrase. Phrase length is approximately 60 characters. </param>
        /// <param name="longPhrase"> Long summary phrase. Phrase length is 60+ characters. </param>
        /// <param name="iconCode"> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </param>
        internal IntervalSummary(int? startMinute, int? endMinute, int? totalMinutes, string shortDescription, string briefDescription, string longPhrase, IconCode? iconCode)
        {
            StartMinute = startMinute;
            EndMinute = endMinute;
            TotalMinutes = totalMinutes;
            ShortDescription = shortDescription;
            BriefDescription = briefDescription;
            LongPhrase = longPhrase;
            IconCode = iconCode;
        }

        /// <summary> The first minute to which the summary applies. </summary>
        public int? StartMinute { get; }
        /// <summary> The last minute to which the summary applies. </summary>
        public int? EndMinute { get; }
        /// <summary> The number of minutes for which the summary applies. </summary>
        public int? TotalMinutes { get; }
        /// <summary> Short summary phrase. Phrase length is approximately 25 characters. </summary>
        public string ShortDescription { get; }
        /// <summary> Brief summary phrase. Phrase length is approximately 60 characters. </summary>
        public string BriefDescription { get; }
        /// <summary> Long summary phrase. Phrase length is 60+ characters. </summary>
        public string LongPhrase { get; }
        /// <summary> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </summary>
        public IconCode? IconCode { get; }
    }
}
