// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;
using System.Globalization;

namespace Azure.Maps.Weather.Models
{
    /// <summary> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </summary>
    public readonly partial struct IconCode : IEquatable<IconCode>
    {
        private readonly int _value;

        /// <summary> Initializes a new instance of <see cref="IconCode"/>. </summary>
        public IconCode(int value)
        {
            _value = value;
        }

        private const int SunnyValue = 1;
        private const int MostlySunnyValue = 2;
        private const int PartlySunnyValue = 3;
        private const int IntermittentCloudsValue = 4;
        private const int HazySunshineValue = 5;
        private const int MostlyCloudyValue = 6;
        private const int CloudyValue = 7;
        private const int DrearyValue = 8;
        private const int FogValue = 11;
        private const int ShowersValue = 12;
        private const int MostlyCloudyWithShowersValue = 13;
        private const int PartlySunnyWithShowersValue = 14;
        private const int ThunderstormsValue = 15;
        private const int MostlyCloudyWithThunderstormsValue = 16;
        private const int PartlySunnyWithThunderstormsValue = 17;
        private const int RainValue = 18;
        private const int FlurriesValue = 19;
        private const int MostlyCloudyWithFlurriesValue = 20;
        private const int PartlySunnyWithFlurriesValue = 21;
        private const int SnowValue = 22;
        private const int MostlyCloudyWithSnowValue = 23;
        private const int IceValue = 24;
        private const int SleetValue = 25;
        private const int FreezingRainValue = 26;
        private const int RainAndSnowValue = 29;
        private const int HotValue = 30;
        private const int ColdValue = 31;
        private const int WindyValue = 32;
        private const int ClearValue = 33;
        private const int MostlyClearValue = 34;
        private const int PartlyCloudyValue = 35;
        private const int IntermittentCloudsNightValue = 36;
        private const int HazyMoonlightValue = 37;
        private const int MostlyCloudyNightValue = 38;
        private const int PartlyCloudyWithShowersValue = 39;
        private const int MostlyCloudyWithShowersNightValue = 40;
        private const int PartlyCloudyWithThunderstormsValue = 41;
        private const int MostlyCloudyWithThunderstormsNightValue = 42;
        private const int MostlyCloudyWithFlurriesNightValue = 43;
        private const int MostlyCloudyWithSnowNightValue = 44;

        /// <summary> Sunny. </summary>
        public static IconCode Sunny { get; } = new IconCode(SunnyValue);
        /// <summary> Mostly Sunny. </summary>
        public static IconCode MostlySunny { get; } = new IconCode(MostlySunnyValue);
        /// <summary> Partly Sunny. </summary>
        public static IconCode PartlySunny { get; } = new IconCode(PartlySunnyValue);
        /// <summary> Intermittent Clouds. </summary>
        public static IconCode IntermittentClouds { get; } = new IconCode(IntermittentCloudsValue);
        /// <summary> Hazy Sunshine. </summary>
        public static IconCode HazySunshine { get; } = new IconCode(HazySunshineValue);
        /// <summary> Mostly Cloudy. </summary>
        public static IconCode MostlyCloudy { get; } = new IconCode(MostlyCloudyValue);
        /// <summary> Cloudy. </summary>
        public static IconCode Cloudy { get; } = new IconCode(CloudyValue);
        /// <summary> Dreary (Overcast). </summary>
        public static IconCode Dreary { get; } = new IconCode(DrearyValue);
        /// <summary> Fog. </summary>
        public static IconCode Fog { get; } = new IconCode(FogValue);
        /// <summary> Showers. </summary>
        public static IconCode Showers { get; } = new IconCode(ShowersValue);
        /// <summary> Mostly Cloudy with Showers. </summary>
        public static IconCode MostlyCloudyWithShowers { get; } = new IconCode(MostlyCloudyWithShowersValue);
        /// <summary> Partly Sunny with Showers. </summary>
        public static IconCode PartlySunnyWithShowers { get; } = new IconCode(PartlySunnyWithShowersValue);
        /// <summary> Thunderstorms. </summary>
        public static IconCode Thunderstorms { get; } = new IconCode(ThunderstormsValue);
        /// <summary> Mostly Cloudy with Thunderstorms. </summary>
        public static IconCode MostlyCloudyWithThunderstorms { get; } = new IconCode(MostlyCloudyWithThunderstormsValue);
        /// <summary> Partly Sunny with Thunderstorms. </summary>
        public static IconCode PartlySunnyWithThunderstorms { get; } = new IconCode(PartlySunnyWithThunderstormsValue);
        /// <summary> Rain. </summary>
        public static IconCode Rain { get; } = new IconCode(RainValue);
        /// <summary> Flurries. </summary>
        public static IconCode Flurries { get; } = new IconCode(FlurriesValue);
        /// <summary> Mostly Cloudy with Flurries. </summary>
        public static IconCode MostlyCloudyWithFlurries { get; } = new IconCode(MostlyCloudyWithFlurriesValue);
        /// <summary> Partly Sunny with Flurries. </summary>
        public static IconCode PartlySunnyWithFlurries { get; } = new IconCode(PartlySunnyWithFlurriesValue);
        /// <summary> Snow. </summary>
        public static IconCode Snow { get; } = new IconCode(SnowValue);
        /// <summary> Mostly Cloudy with Snow. </summary>
        public static IconCode MostlyCloudyWithSnow { get; } = new IconCode(MostlyCloudyWithSnowValue);
        /// <summary> Ice. </summary>
        public static IconCode Ice { get; } = new IconCode(IceValue);
        /// <summary> Sleet. </summary>
        public static IconCode Sleet { get; } = new IconCode(SleetValue);
        /// <summary> Freezing Rain. </summary>
        public static IconCode FreezingRain { get; } = new IconCode(FreezingRainValue);
        /// <summary> Rain and Snow. </summary>
        public static IconCode RainAndSnow { get; } = new IconCode(RainAndSnowValue);
        /// <summary> Hot. </summary>
        public static IconCode Hot { get; } = new IconCode(HotValue);
        /// <summary> Cold. </summary>
        public static IconCode Cold { get; } = new IconCode(ColdValue);
        /// <summary> Windy. </summary>
        public static IconCode Windy { get; } = new IconCode(WindyValue);
        /// <summary> Clear. </summary>
        public static IconCode Clear { get; } = new IconCode(ClearValue);
        /// <summary> Mostly Clear. </summary>
        public static IconCode MostlyClear { get; } = new IconCode(MostlyClearValue);
        /// <summary> Partly Cloudy. </summary>
        public static IconCode PartlyCloudy { get; } = new IconCode(PartlyCloudyValue);
        /// <summary> Intermittent Clouds (Night). </summary>
        public static IconCode IntermittentCloudsNight { get; } = new IconCode(IntermittentCloudsNightValue);
        /// <summary> Hazy Moonlight. </summary>
        public static IconCode HazyMoonlight { get; } = new IconCode(HazyMoonlightValue);
        /// <summary> Mostly Cloudy (Night). </summary>
        public static IconCode MostlyCloudyNight { get; } = new IconCode(MostlyCloudyNightValue);
        /// <summary> Partly Cloudy with Showers. </summary>
        public static IconCode PartlyCloudyWithShowers { get; } = new IconCode(PartlyCloudyWithShowersValue);
        /// <summary> Mostly Cloudy with Showers (Night). </summary>
        public static IconCode MostlyCloudyWithShowersNight { get; } = new IconCode(MostlyCloudyWithShowersNightValue);
        /// <summary> Partly Cloudy with Thunderstorms. </summary>
        public static IconCode PartlyCloudyWithThunderstorms { get; } = new IconCode(PartlyCloudyWithThunderstormsValue);
        /// <summary> Mostly Cloudy with Thunderstorms (Night). </summary>
        public static IconCode MostlyCloudyWithThunderstormsNight { get; } = new IconCode(MostlyCloudyWithThunderstormsNightValue);
        /// <summary> Mostly Cloudy with Flurries (Night). </summary>
        public static IconCode MostlyCloudyWithFlurriesNight { get; } = new IconCode(MostlyCloudyWithFlurriesNightValue);
        /// <summary> Mostly Cloudy with Snow (Night). </summary>
        public static IconCode MostlyCloudyWithSnowNight { get; } = new IconCode(MostlyCloudyWithSnowNightValue);

        internal int ToSerialInt32() => _value;

        /// <summary> Determines if two <see cref="IconCode"/> values are the same. </summary>
        public static bool operator ==(IconCode left, IconCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="IconCode"/> values are not the same. </summary>
        public static bool operator !=(IconCode left, IconCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="int"/> to a <see cref="IconCode"/>. </summary>
        public static implicit operator IconCode(int value) => new IconCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is IconCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(IconCode other) => Equals(_value, other._value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value.GetHashCode();
        /// <inheritdoc />
        public override string ToString() => _value.ToString(CultureInfo.InvariantCulture);
    }
}
