// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class HourlyForecast
    {
        internal static HourlyForecast DeserializeHourlyForecast(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? date = default;
            IconCode? iconCode = default;
            string iconPhrase = default;
            bool? hasPrecipitation = default;
            bool? isDaylight = default;
            WeatherValue temperature = default;
            WeatherValue realFeelTemperature = default;
            WeatherValue wetBulbTemperature = default;
            WeatherValue dewPoint = default;
            WindDetails wind = default;
            WindDetails windGust = default;
            int? relativeHumidity = default;
            WeatherValue visibility = default;
            WeatherValue ceiling = default;
            int? uvIndex = default;
            string uvIndexPhrase = default;
            int? precipitationProbability = default;
            int? rainProbability = default;
            int? snowProbability = default;
            int? iceProbability = default;
            WeatherValue totalLiquid = default;
            WeatherValue rain = default;
            WeatherValue snow = default;
            WeatherValue ice = default;
            int? cloudCover = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("date"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    date = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("iconCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    iconCode = new IconCode(property.Value.GetInt32());
                    continue;
                }
                if (property.NameEquals("iconPhrase"u8))
                {
                    iconPhrase = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("hasPrecipitation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hasPrecipitation = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isDaylight"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isDaylight = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("temperature"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    temperature = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("realFeelTemperature"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    realFeelTemperature = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("wetBulbTemperature"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    wetBulbTemperature = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("dewPoint"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dewPoint = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("wind"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    wind = WindDetails.DeserializeWindDetails(property.Value);
                    continue;
                }
                if (property.NameEquals("windGust"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    windGust = WindDetails.DeserializeWindDetails(property.Value);
                    continue;
                }
                if (property.NameEquals("relativeHumidity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    relativeHumidity = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("visibility"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    visibility = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("ceiling"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ceiling = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("uvIndex"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    uvIndex = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("uvIndexPhrase"u8))
                {
                    uvIndexPhrase = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("precipitationProbability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    precipitationProbability = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("rainProbability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rainProbability = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("snowProbability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    snowProbability = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("iceProbability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    iceProbability = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("totalLiquid"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalLiquid = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("rain"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rain = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("snow"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    snow = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("ice"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ice = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("cloudCover"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cloudCover = property.Value.GetInt32();
                    continue;
                }
            }
            return new HourlyForecast(
                date,
                iconCode,
                iconPhrase,
                hasPrecipitation,
                isDaylight,
                temperature,
                realFeelTemperature,
                wetBulbTemperature,
                dewPoint,
                wind,
                windGust,
                relativeHumidity,
                visibility,
                ceiling,
                uvIndex,
                uvIndexPhrase,
                precipitationProbability,
                rainProbability,
                snowProbability,
                iceProbability,
                totalLiquid,
                rain,
                snow,
                ice,
                cloudCover);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static HourlyForecast FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeHourlyForecast(document.RootElement);
        }
    }
}
