// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;
using System.Globalization;

namespace Azure.Maps.Weather.Models
{
    /// <summary>
    /// A severity/hazard index.
    ///   * `0` - No hazard.
    ///   * `1` - Be informed, be aware.
    ///   * `2` - Pay attention, be prepared.
    ///   * `3` - Take action.
    ///   * `4` - Life threatening, emergency.
    /// </summary>
    public readonly partial struct HazardIndex : IEquatable<HazardIndex>
    {
        private readonly int _value;

        /// <summary> Initializes a new instance of <see cref="HazardIndex"/>. </summary>
        public HazardIndex(int value)
        {
            _value = value;
        }

        private const int NoHazardValue = 0;
        private const int InformedValue = 1;
        private const int PayAttentionValue = 2;
        private const int TakeActionValue = 3;
        private const int EmergencyValue = 4;

        /// <summary> No hazard. </summary>
        public static HazardIndex NoHazard { get; } = new HazardIndex(NoHazardValue);
        /// <summary> Be informed. </summary>
        public static HazardIndex Informed { get; } = new HazardIndex(InformedValue);
        /// <summary> Pay attention. </summary>
        public static HazardIndex PayAttention { get; } = new HazardIndex(PayAttentionValue);
        /// <summary> Take action. </summary>
        public static HazardIndex TakeAction { get; } = new HazardIndex(TakeActionValue);
        /// <summary> Emergency. </summary>
        public static HazardIndex Emergency { get; } = new HazardIndex(EmergencyValue);

        internal int ToSerialInt32() => _value;

        /// <summary> Determines if two <see cref="HazardIndex"/> values are the same. </summary>
        public static bool operator ==(HazardIndex left, HazardIndex right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HazardIndex"/> values are not the same. </summary>
        public static bool operator !=(HazardIndex left, HazardIndex right) => !left.Equals(right);
        /// <summary> Converts a <see cref="int"/> to a <see cref="HazardIndex"/>. </summary>
        public static implicit operator HazardIndex(int value) => new HazardIndex(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HazardIndex other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HazardIndex other) => Equals(_value, other._value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value.GetHashCode();
        /// <inheritdoc />
        public override string ToString() => _value.ToString(CultureInfo.InvariantCulture);
    }
}
