// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Maps.Weather.Models
{
    /// <summary> The HazardDetail. </summary>
    public partial class HazardDetail
    {
        /// <summary> Initializes a new instance of <see cref="HazardDetail"/>. </summary>
        internal HazardDetail()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HazardDetail"/>. </summary>
        /// <param name="hazardIndex">
        /// A severity/hazard index.
        ///   * `0` - No hazard.
        ///   * `1` - Be informed, be aware.
        ///   * `2` - Pay attention, be prepared.
        ///   * `3` - Take action.
        ///   * `4` - Life threatening, emergency.
        /// </param>
        /// <param name="hazardCode"> A unique identifier (non-displayable) for each type of hazard: LightRain, ModerateRain, HeavyRain, LightMix, ModerateMix, HeavyMix, LightSnow, ModerateSnow, HeavySnow, LightIce, ModerateIce, HeavyIce, Hail, LargeHail, SunGlare, SunGlareHigh, Lightning, SevereLightning, WindModerate, WindHigh, WindExtreme, FloodWarning, FlashFloodWarning, TornadoWarning, TsunamiWarning, SevereThunderstormWarning. </param>
        /// <param name="shortDescription"> A displayable short phrase describing the forecasted conditions and precipitation intensity/type. </param>
        internal HazardDetail(HazardIndex? hazardIndex, string hazardCode, string shortDescription)
        {
            HazardIndex = hazardIndex;
            HazardCode = hazardCode;
            ShortDescription = shortDescription;
        }

        /// <summary>
        /// A severity/hazard index.
        ///   * `0` - No hazard.
        ///   * `1` - Be informed, be aware.
        ///   * `2` - Pay attention, be prepared.
        ///   * `3` - Take action.
        ///   * `4` - Life threatening, emergency.
        /// </summary>
        public HazardIndex? HazardIndex { get; }
        /// <summary> A unique identifier (non-displayable) for each type of hazard: LightRain, ModerateRain, HeavyRain, LightMix, ModerateMix, HeavyMix, LightSnow, ModerateSnow, HeavySnow, LightIce, ModerateIce, HeavyIce, Hail, LargeHail, SunGlare, SunGlareHigh, Lightning, SevereLightning, WindModerate, WindHigh, WindExtreme, FloodWarning, FlashFloodWarning, TornadoWarning, TsunamiWarning, SevereThunderstormWarning. </summary>
        public string HazardCode { get; }
        /// <summary> A displayable short phrase describing the forecasted conditions and precipitation intensity/type. </summary>
        public string ShortDescription { get; }
    }
}
