// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Maps.Weather.Models
{
    internal static partial class GeoJsonObjectTypeExtensions
    {
        public static string ToSerialString(this GeoJsonObjectType value) => value switch
        {
            GeoJsonObjectType.GeoJsonPoint => "Point",
            GeoJsonObjectType.GeoJsonMultiPoint => "MultiPoint",
            GeoJsonObjectType.GeoJsonLineString => "LineString",
            GeoJsonObjectType.GeoJsonMultiLineString => "MultiLineString",
            GeoJsonObjectType.GeoJsonPolygon => "Polygon",
            GeoJsonObjectType.GeoJsonMultiPolygon => "MultiPolygon",
            GeoJsonObjectType.GeoJsonGeometryCollection => "GeometryCollection",
            GeoJsonObjectType.GeoJsonFeature => "Feature",
            GeoJsonObjectType.GeoJsonFeatureCollection => "FeatureCollection",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown GeoJsonObjectType value.")
        };

        public static GeoJsonObjectType ToGeoJsonObjectType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Point")) return GeoJsonObjectType.GeoJsonPoint;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "MultiPoint")) return GeoJsonObjectType.GeoJsonMultiPoint;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "LineString")) return GeoJsonObjectType.GeoJsonLineString;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "MultiLineString")) return GeoJsonObjectType.GeoJsonMultiLineString;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Polygon")) return GeoJsonObjectType.GeoJsonPolygon;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "MultiPolygon")) return GeoJsonObjectType.GeoJsonMultiPolygon;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "GeometryCollection")) return GeoJsonObjectType.GeoJsonGeometryCollection;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Feature")) return GeoJsonObjectType.GeoJsonFeature;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "FeatureCollection")) return GeoJsonObjectType.GeoJsonFeatureCollection;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown GeoJsonObjectType value.");
        }
    }
}
