// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Maps.Weather.Models
{
    internal partial class GeoJsonGeometryCollection
    {
        internal static GeoJsonGeometryCollection DeserializeGeoJsonGeometryCollection(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<GeoJsonGeometry> geometries = default;
            GeoJsonObjectType type = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("geometries"u8))
                {
                    List<GeoJsonGeometry> array = new List<GeoJsonGeometry>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DeserializeGeoJsonGeometry(item));
                    }
                    geometries = array;
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = property.Value.GetString().ToGeoJsonObjectType();
                    continue;
                }
            }
            return new GeoJsonGeometryCollection(type, geometries);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static new GeoJsonGeometryCollection FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeGeoJsonGeometryCollection(document.RootElement);
        }
    }
}
