// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class ForecastInterval
    {
        internal static ForecastInterval DeserializeForecastInterval(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? startTime = default;
            int? minute = default;
            double? dbz = default;
            string shortPhrase = default;
            string threshold = default;
            ColorValue color = default;
            ColorValue simplifiedColor = default;
            PrecipitationType? precipitationType = default;
            IconCode? iconCode = default;
            int? cloudCover = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("startTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("minute"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    minute = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("dbz"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dbz = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("shortPhrase"u8))
                {
                    shortPhrase = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("threshold"u8))
                {
                    threshold = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("color"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    color = ColorValue.DeserializeColorValue(property.Value);
                    continue;
                }
                if (property.NameEquals("simplifiedColor"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    simplifiedColor = ColorValue.DeserializeColorValue(property.Value);
                    continue;
                }
                if (property.NameEquals("precipitationType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    precipitationType = new PrecipitationType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("iconCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    iconCode = new IconCode(property.Value.GetInt32());
                    continue;
                }
                if (property.NameEquals("cloudCover"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cloudCover = property.Value.GetInt32();
                    continue;
                }
            }
            return new ForecastInterval(
                startTime,
                minute,
                dbz,
                shortPhrase,
                threshold,
                color,
                simplifiedColor,
                precipitationType,
                iconCode,
                cloudCover);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ForecastInterval FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeForecastInterval(document.RootElement);
        }
    }
}
