// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Weather.Models
{
    /// <summary> Type of pollutant. Please note that more may be added at any time. </summary>
    public readonly partial struct DominantPollutant : IEquatable<DominantPollutant>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DominantPollutant"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DominantPollutant(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CarbonMonoxideValue = "Carbon Monoxide";
        private const string NitrogenDioxideValue = "Nitrogen Dioxide";
        private const string OzoneValue = "Ozone";
        private const string ParticulateMatter25Value = "Particulate Matter 2.5";
        private const string ParticulateMatter10Value = "Particulate Matter 10";
        private const string SulfurDioxideValue = "Sulfur Dioxide";

        /// <summary> Carbon monoxide ("CO"). </summary>
        public static DominantPollutant CarbonMonoxide { get; } = new DominantPollutant(CarbonMonoxideValue);
        /// <summary> Nitrogen dioxide ("NO2"). </summary>
        public static DominantPollutant NitrogenDioxide { get; } = new DominantPollutant(NitrogenDioxideValue);
        /// <summary> Ozone ("O3"). </summary>
        public static DominantPollutant Ozone { get; } = new DominantPollutant(OzoneValue);
        /// <summary> Particulate matter 2.5 ("PM2.5"). </summary>
        public static DominantPollutant ParticulateMatter25 { get; } = new DominantPollutant(ParticulateMatter25Value);
        /// <summary> Particulate matter 10 ("PM10"). </summary>
        public static DominantPollutant ParticulateMatter10 { get; } = new DominantPollutant(ParticulateMatter10Value);
        /// <summary> Sulfur dioxide ("SO2"). </summary>
        public static DominantPollutant SulfurDioxide { get; } = new DominantPollutant(SulfurDioxideValue);
        /// <summary> Determines if two <see cref="DominantPollutant"/> values are the same. </summary>
        public static bool operator ==(DominantPollutant left, DominantPollutant right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DominantPollutant"/> values are not the same. </summary>
        public static bool operator !=(DominantPollutant left, DominantPollutant right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DominantPollutant"/>. </summary>
        public static implicit operator DominantPollutant(string value) => new DominantPollutant(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DominantPollutant other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DominantPollutant other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
