// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    /// <summary> This object is returned from a successful Get Daily Indices call. </summary>
    public partial class DailyIndicesResult
    {
        /// <summary> Initializes a new instance of <see cref="DailyIndicesResult"/>. </summary>
        internal DailyIndicesResult()
        {
            Results = new ChangeTrackingList<DailyIndex>();
        }

        /// <summary> Initializes a new instance of <see cref="DailyIndicesResult"/>. </summary>
        /// <param name="results"> A list of all daily indices for the queried location. </param>
        internal DailyIndicesResult(IReadOnlyList<DailyIndex> results)
        {
            Results = results;
        }

        /// <summary> A list of all daily indices for the queried location. </summary>
        public IReadOnlyList<DailyIndex> Results { get; }
    }
}
