// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Maps.Weather.Models
{
    /// <summary> Information about a daily index. </summary>
    public partial class DailyIndex
    {
        /// <summary> Initializes a new instance of <see cref="DailyIndex"/>. </summary>
        internal DailyIndex()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DailyIndex"/>. </summary>
        /// <param name="indexName"> Name of the index, for example, "Construction", "Outdoor Activity", "Flight Delays". </param>
        /// <param name="indexId"> Numeric ID used to identify the specific index. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#daily-index-range-sets) for details and to see the supported index IDs. For example, the index ID can support UI visualization scenarios. </param>
        /// <param name="dateTime"> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="value"> Index value. Ranges from 0.0 to 10.0. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#daily-index-range-sets) for details and to see the supported ranges. </param>
        /// <param name="categoryDescription"> Textual description for `categoryValue` corresponding to the level that the index value falls under, for example "Very Good". </param>
        /// <param name="categoryValue"> Level that the index value falls under, represented by an integer. This value can be 1 through 5 and should be used in combination with the `ascending` flag because it can differ among indices. For example, the following values apply for Mosquito Activity: Low=1, Moderate=2, High=3, Very High=4, and Extreme=5. </param>
        /// <param name="isAscending"> Describes the direction of the `value` and `categoryValue`. For example, when set to `true`, the poorest index value is 0 and the best index value is 10. When set to `true`, the poorest index value is 10 and the best index value is 0. </param>
        /// <param name="description"> A textual explanation that can be used for display purposes to summarize the index value and category. For example, when the index value for Flight Delays is very good, the description will be "Conditions are excellent for flying!". </param>
        internal DailyIndex(string indexName, int? indexId, DateTimeOffset? dateTime, float? value, string categoryDescription, int? categoryValue, bool? isAscending, string description)
        {
            IndexName = indexName;
            IndexId = indexId;
            DateTime = dateTime;
            Value = value;
            CategoryDescription = categoryDescription;
            CategoryValue = categoryValue;
            IsAscending = isAscending;
            Description = description;
        }

        /// <summary> Name of the index, for example, "Construction", "Outdoor Activity", "Flight Delays". </summary>
        public string IndexName { get; }
        /// <summary> Numeric ID used to identify the specific index. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#daily-index-range-sets) for details and to see the supported index IDs. For example, the index ID can support UI visualization scenarios. </summary>
        public int? IndexId { get; }
        /// <summary> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </summary>
        public DateTimeOffset? DateTime { get; }
        /// <summary> Index value. Ranges from 0.0 to 10.0. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#daily-index-range-sets) for details and to see the supported ranges. </summary>
        public float? Value { get; }
        /// <summary> Textual description for `categoryValue` corresponding to the level that the index value falls under, for example "Very Good". </summary>
        public string CategoryDescription { get; }
        /// <summary> Level that the index value falls under, represented by an integer. This value can be 1 through 5 and should be used in combination with the `ascending` flag because it can differ among indices. For example, the following values apply for Mosquito Activity: Low=1, Moderate=2, High=3, Very High=4, and Extreme=5. </summary>
        public int? CategoryValue { get; }
        /// <summary> Describes the direction of the `value` and `categoryValue`. For example, when set to `true`, the poorest index value is 0 and the best index value is 10. When set to `true`, the poorest index value is 10 and the best index value is 0. </summary>
        public bool? IsAscending { get; }
        /// <summary> A textual explanation that can be used for display purposes to summarize the index value and category. For example, when the index value for Flight Delays is very good, the description will be "Conditions are excellent for flying!". </summary>
        public string Description { get; }
    }
}
