// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class DailyIndex
    {
        internal static DailyIndex DeserializeDailyIndex(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string indexName = default;
            int? indexId = default;
            DateTimeOffset? dateTime = default;
            float? value = default;
            string category = default;
            int? categoryValue = default;
            bool? @ascending = default;
            string description = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("indexName"u8))
                {
                    indexName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("indexId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    indexId = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("dateTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dateTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("value"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    value = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("category"u8))
                {
                    category = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("categoryValue"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    categoryValue = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("ascending"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    @ascending = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("description"u8))
                {
                    description = property.Value.GetString();
                    continue;
                }
            }
            return new DailyIndex(
                indexName,
                indexId,
                dateTime,
                value,
                category,
                categoryValue,
                @ascending,
                description);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DailyIndex FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDailyIndex(document.RootElement);
        }
    }
}
