// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Maps.Weather.Models
{
    /// <summary> The DailyHistoricalRecords. </summary>
    public partial class DailyHistoricalRecords
    {
        /// <summary> Initializes a new instance of <see cref="DailyHistoricalRecords"/>. </summary>
        internal DailyHistoricalRecords()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DailyHistoricalRecords"/>. </summary>
        /// <param name="timestamp"> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="temperature"> Temperature value. </param>
        /// <param name="precipitation"> Maximum amount of precipitation (liquid equivalent) that has fallen. </param>
        /// <param name="snowfall"> Maximum snowfall. </param>
        internal DailyHistoricalRecords(DateTimeOffset? timestamp, WeatherValueYearMaxMinAvg temperature, WeatherValueYearMax precipitation, WeatherValueYearMax snowfall)
        {
            Timestamp = timestamp;
            Temperature = temperature;
            Precipitation = precipitation;
            Snowfall = snowfall;
        }

        /// <summary> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </summary>
        public DateTimeOffset? Timestamp { get; }
        /// <summary> Temperature value. </summary>
        public WeatherValueYearMaxMinAvg Temperature { get; }
        /// <summary> Maximum amount of precipitation (liquid equivalent) that has fallen. </summary>
        public WeatherValueYearMax Precipitation { get; }
        /// <summary> Maximum snowfall. </summary>
        public WeatherValueYearMax Snowfall { get; }
    }
}
