// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    /// <summary> The DailyHistoricalNormalsResult. </summary>
    public partial class DailyHistoricalNormalsResult
    {
        /// <summary> Initializes a new instance of <see cref="DailyHistoricalNormalsResult"/>. </summary>
        internal DailyHistoricalNormalsResult()
        {
            HistoricalNormals = new ChangeTrackingList<DailyHistoricalNormals>();
        }

        /// <summary> Initializes a new instance of <see cref="DailyHistoricalNormalsResult"/>. </summary>
        /// <param name="historicalNormals"> Historical normals for each requested day. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        internal DailyHistoricalNormalsResult(IReadOnlyList<DailyHistoricalNormals> historicalNormals, string nextLink)
        {
            HistoricalNormals = historicalNormals;
            NextLink = nextLink;
        }

        /// <summary> Historical normals for each requested day. </summary>
        public IReadOnlyList<DailyHistoricalNormals> HistoricalNormals { get; }
        /// <summary> The is the link to the next page of the features returned. If it's the last page, no this field. </summary>
        public string NextLink { get; }
    }
}
