// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Maps.Weather.Models
{
    /// <summary> The DailyHistoricalNormals. </summary>
    public partial class DailyHistoricalNormals
    {
        /// <summary> Initializes a new instance of <see cref="DailyHistoricalNormals"/>. </summary>
        internal DailyHistoricalNormals()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DailyHistoricalNormals"/>. </summary>
        /// <param name="timestamp"> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="temperature"> Temperature values. </param>
        /// <param name="degreeDaySummary"> Summary of heating or cooling degree day information. </param>
        /// <param name="precipitation"> The amount of precipitation (liquid equivalent) that has fallen. </param>
        internal DailyHistoricalNormals(DateTimeOffset? timestamp, WeatherValueMaxMinAvg temperature, DegreeDaySummary degreeDaySummary, WeatherValue precipitation)
        {
            Timestamp = timestamp;
            Temperature = temperature;
            DegreeDaySummary = degreeDaySummary;
            Precipitation = precipitation;
        }

        /// <summary> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </summary>
        public DateTimeOffset? Timestamp { get; }
        /// <summary> Temperature values. </summary>
        public WeatherValueMaxMinAvg Temperature { get; }
        /// <summary> Summary of heating or cooling degree day information. </summary>
        public DegreeDaySummary DegreeDaySummary { get; }
        /// <summary> The amount of precipitation (liquid equivalent) that has fallen. </summary>
        public WeatherValue Precipitation { get; }
    }
}
