// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    /// <summary> The DailyHistoricalActualsResult. </summary>
    public partial class DailyHistoricalActualsResult
    {
        /// <summary> Initializes a new instance of <see cref="DailyHistoricalActualsResult"/>. </summary>
        internal DailyHistoricalActualsResult()
        {
            HistoricalActuals = new ChangeTrackingList<DailyHistoricalActuals>();
        }

        /// <summary> Initializes a new instance of <see cref="DailyHistoricalActualsResult"/>. </summary>
        /// <param name="historicalActuals"> Historical actuals for each requested day. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        internal DailyHistoricalActualsResult(IReadOnlyList<DailyHistoricalActuals> historicalActuals, string nextLink)
        {
            HistoricalActuals = historicalActuals;
            NextLink = nextLink;
        }

        /// <summary> Historical actuals for each requested day. </summary>
        public IReadOnlyList<DailyHistoricalActuals> HistoricalActuals { get; }
        /// <summary> The is the link to the next page of the features returned. If it's the last page, no this field. </summary>
        public string NextLink { get; }
    }
}
