// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Maps.Weather.Models
{
    /// <summary> The DailyHistoricalActuals. </summary>
    public partial class DailyHistoricalActuals
    {
        /// <summary> Initializes a new instance of <see cref="DailyHistoricalActuals"/>. </summary>
        internal DailyHistoricalActuals()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DailyHistoricalActuals"/>. </summary>
        /// <param name="timestamp"> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="temperature"> Temperature values. </param>
        /// <param name="degreeDaySummary"> Summary of heating or cooling degree day information. Degree days are measures of how cold or warm a location is. A degree day compares the mean (the average of the high and low) outdoor temperatures recorded for a location to a standard temperature of 65 degrees F/ 18 degree C. </param>
        /// <param name="precipitation"> The amount of precipitation (liquid equivalent) that has fallen. </param>
        /// <param name="snowfall"> The amount of snow that has fallen. </param>
        /// <param name="snowDepth"> Snow depth. </param>
        internal DailyHistoricalActuals(DateTimeOffset? timestamp, WeatherValueMaxMinAvg temperature, DegreeDaySummary degreeDaySummary, WeatherValue precipitation, WeatherValue snowfall, WeatherValue snowDepth)
        {
            Timestamp = timestamp;
            Temperature = temperature;
            DegreeDaySummary = degreeDaySummary;
            Precipitation = precipitation;
            Snowfall = snowfall;
            SnowDepth = snowDepth;
        }

        /// <summary> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </summary>
        public DateTimeOffset? Timestamp { get; }
        /// <summary> Temperature values. </summary>
        public WeatherValueMaxMinAvg Temperature { get; }
        /// <summary> Summary of heating or cooling degree day information. Degree days are measures of how cold or warm a location is. A degree day compares the mean (the average of the high and low) outdoor temperatures recorded for a location to a standard temperature of 65 degrees F/ 18 degree C. </summary>
        public DegreeDaySummary DegreeDaySummary { get; }
        /// <summary> The amount of precipitation (liquid equivalent) that has fallen. </summary>
        public WeatherValue Precipitation { get; }
        /// <summary> The amount of snow that has fallen. </summary>
        public WeatherValue Snowfall { get; }
        /// <summary> Snow depth. </summary>
        public WeatherValue SnowDepth { get; }
    }
}
