// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class DailyHistoricalActuals
    {
        internal static DailyHistoricalActuals DeserializeDailyHistoricalActuals(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? date = default;
            WeatherValueMaxMinAvg temperature = default;
            DegreeDaySummary degreeDaySummary = default;
            WeatherValue precipitation = default;
            WeatherValue snowfall = default;
            WeatherValue snowDepth = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("date"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    date = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("temperature"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    temperature = WeatherValueMaxMinAvg.DeserializeWeatherValueMaxMinAvg(property.Value);
                    continue;
                }
                if (property.NameEquals("degreeDaySummary"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    degreeDaySummary = DegreeDaySummary.DeserializeDegreeDaySummary(property.Value);
                    continue;
                }
                if (property.NameEquals("precipitation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    precipitation = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("snowfall"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    snowfall = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("snowDepth"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    snowDepth = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
            }
            return new DailyHistoricalActuals(
                date,
                temperature,
                degreeDaySummary,
                precipitation,
                snowfall,
                snowDepth);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DailyHistoricalActuals FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDailyHistoricalActuals(document.RootElement);
        }
    }
}
