// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Maps.Weather.Models
{
    /// <summary> Summary for the main conditions for the requested time period. Notice that summary can cover only part of the time period. </summary>
    public partial class DailyForecastSummary
    {
        /// <summary> Initializes a new instance of <see cref="DailyForecastSummary"/>. </summary>
        internal DailyForecastSummary()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DailyForecastSummary"/>. </summary>
        /// <param name="startDate"> Date and time that the summary is in effect, displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="endDate"> Date and time that the summary period ends, displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="severity"> severity. </param>
        /// <param name="phrase"> Summary phrase of the daily forecast.  Displayed in specified language. </param>
        /// <param name="category"> one or 2 word(s) to summarize the phrase. </param>
        internal DailyForecastSummary(DateTimeOffset? startDate, DateTimeOffset? endDate, int? severity, string phrase, string category)
        {
            StartDate = startDate;
            EndDate = endDate;
            Severity = severity;
            Phrase = phrase;
            Category = category;
        }

        /// <summary> Date and time that the summary is in effect, displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </summary>
        public DateTimeOffset? StartDate { get; }
        /// <summary> Date and time that the summary period ends, displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </summary>
        public DateTimeOffset? EndDate { get; }
        /// <summary> severity. </summary>
        public int? Severity { get; }
        /// <summary> Summary phrase of the daily forecast.  Displayed in specified language. </summary>
        public string Phrase { get; }
        /// <summary> one or 2 word(s) to summarize the phrase. </summary>
        public string Category { get; }
    }
}
