// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    /// <summary> The DailyForecastResult. </summary>
    public partial class DailyForecastResult
    {
        /// <summary> Initializes a new instance of <see cref="DailyForecastResult"/>. </summary>
        internal DailyForecastResult()
        {
            Forecasts = new ChangeTrackingList<DailyForecast>();
        }

        /// <summary> Initializes a new instance of <see cref="DailyForecastResult"/>. </summary>
        /// <param name="summary"> Summary for the main conditions for the requested time period. Notice that summary can cover only part of the time period. </param>
        /// <param name="forecasts"> Forecast data for each requested day. </param>
        internal DailyForecastResult(DailyForecastSummary summary, IReadOnlyList<DailyForecast> forecasts)
        {
            Summary = summary;
            Forecasts = forecasts;
        }

        /// <summary> Summary for the main conditions for the requested time period. Notice that summary can cover only part of the time period. </summary>
        public DailyForecastSummary Summary { get; }
        /// <summary> Forecast data for each requested day. </summary>
        public IReadOnlyList<DailyForecast> Forecasts { get; }
    }
}
