// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class DailyForecastResult
    {
        internal static DailyForecastResult DeserializeDailyForecastResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DailyForecastSummary summary = default;
            IReadOnlyList<DailyForecast> forecasts = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("summary"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    summary = DailyForecastSummary.DeserializeDailyForecastSummary(property.Value);
                    continue;
                }
                if (property.NameEquals("forecasts"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<DailyForecast> array = new List<DailyForecast>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(DailyForecast.DeserializeDailyForecast(item));
                    }
                    forecasts = array;
                    continue;
                }
            }
            return new DailyForecastResult(summary, forecasts ?? new ChangeTrackingList<DailyForecast>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DailyForecastResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDailyForecastResult(document.RootElement);
        }
    }
}
