// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Weather.Models
{
    public partial class DailyForecastDetail
    {
        internal static DailyForecastDetail DeserializeDailyForecastDetail(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IconCode? iconCode = default;
            string iconPhrase = default;
            LocalSource localSource = default;
            bool? hasPrecipitation = default;
            PrecipitationType? precipitationType = default;
            string precipitationIntensity = default;
            string shortPhrase = default;
            string longPhrase = default;
            int? precipitationProbability = default;
            int? thunderstormProbability = default;
            int? rainProbability = default;
            int? snowProbability = default;
            int? iceProbability = default;
            WindDetails wind = default;
            WindDetails windGust = default;
            WeatherValue totalLiquid = default;
            WeatherValue rain = default;
            WeatherValue snow = default;
            WeatherValue ice = default;
            float? hoursOfPrecipitation = default;
            float? hoursOfRain = default;
            float? hoursOfSnow = default;
            float? hoursOfIce = default;
            int? cloudCover = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("iconCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    iconCode = new IconCode(property.Value.GetInt32());
                    continue;
                }
                if (property.NameEquals("iconPhrase"u8))
                {
                    iconPhrase = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("localSource"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    localSource = LocalSource.DeserializeLocalSource(property.Value);
                    continue;
                }
                if (property.NameEquals("hasPrecipitation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hasPrecipitation = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("precipitationType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    precipitationType = new PrecipitationType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("precipitationIntensity"u8))
                {
                    precipitationIntensity = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("shortPhrase"u8))
                {
                    shortPhrase = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("longPhrase"u8))
                {
                    longPhrase = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("precipitationProbability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    precipitationProbability = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("thunderstormProbability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    thunderstormProbability = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("rainProbability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rainProbability = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("snowProbability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    snowProbability = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("iceProbability"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    iceProbability = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("wind"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    wind = WindDetails.DeserializeWindDetails(property.Value);
                    continue;
                }
                if (property.NameEquals("windGust"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    windGust = WindDetails.DeserializeWindDetails(property.Value);
                    continue;
                }
                if (property.NameEquals("totalLiquid"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    totalLiquid = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("rain"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rain = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("snow"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    snow = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("ice"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ice = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("hoursOfPrecipitation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hoursOfPrecipitation = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("hoursOfRain"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hoursOfRain = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("hoursOfSnow"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hoursOfSnow = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("hoursOfIce"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hoursOfIce = property.Value.GetSingle();
                    continue;
                }
                if (property.NameEquals("cloudCover"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cloudCover = property.Value.GetInt32();
                    continue;
                }
            }
            return new DailyForecastDetail(
                iconCode,
                iconPhrase,
                localSource,
                hasPrecipitation,
                precipitationType,
                precipitationIntensity,
                shortPhrase,
                longPhrase,
                precipitationProbability,
                thunderstormProbability,
                rainProbability,
                snowProbability,
                iceProbability,
                wind,
                windGust,
                totalLiquid,
                rain,
                snow,
                ice,
                hoursOfPrecipitation,
                hoursOfRain,
                hoursOfSnow,
                hoursOfIce,
                cloudCover);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static DailyForecastDetail FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeDailyForecastDetail(document.RootElement);
        }
    }
}
