// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    /// <summary> This object is returned from a successful Get Daily Air Quality Forecast call. </summary>
    public partial class DailyAirQualityForecastResult
    {
        /// <summary> Initializes a new instance of <see cref="DailyAirQualityForecastResult"/>. </summary>
        internal DailyAirQualityForecastResult()
        {
            AirQualityResults = new ChangeTrackingList<DailyAirQuality>();
        }

        /// <summary> Initializes a new instance of <see cref="DailyAirQualityForecastResult"/>. </summary>
        /// <param name="airQualityResults"> A list of all daily air quality forecasts for the queried location. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        internal DailyAirQualityForecastResult(IReadOnlyList<DailyAirQuality> airQualityResults, string nextLink)
        {
            AirQualityResults = airQualityResults;
            NextLink = nextLink;
        }

        /// <summary> A list of all daily air quality forecasts for the queried location. </summary>
        public IReadOnlyList<DailyAirQuality> AirQualityResults { get; }
        /// <summary> The is the link to the next page of the features returned. If it's the last page, no this field. </summary>
        public string NextLink { get; }
    }
}
