// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class CurrentConditionsResult
    {
        internal static CurrentConditionsResult DeserializeCurrentConditionsResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<CurrentConditions> results = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("results"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<CurrentConditions> array = new List<CurrentConditions>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(CurrentConditions.DeserializeCurrentConditions(item));
                    }
                    results = array;
                    continue;
                }
            }
            return new CurrentConditionsResult(results ?? new ChangeTrackingList<CurrentConditions>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static CurrentConditionsResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeCurrentConditionsResult(document.RootElement);
        }
    }
}
