// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Maps.Weather.Models
{
    /// <summary> The CurrentConditions. </summary>
    public partial class CurrentConditions
    {
        /// <summary> Initializes a new instance of <see cref="CurrentConditions"/>. </summary>
        internal CurrentConditions()
        {
        }

        /// <summary> Initializes a new instance of <see cref="CurrentConditions"/>. </summary>
        /// <param name="dateTime"> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="description"> Phrase description of the current weather condition.  Displayed in specified language. </param>
        /// <param name="iconCode"> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </param>
        /// <param name="hasPrecipitation"> Indicates the presence or absence of precipitation. True indicates the presence of precipitation, false indicates the absence of precipitation. </param>
        /// <param name="isDaytime"> Indicates the time of the day. True indicates 'day',', false indicates 'night. </param>
        /// <param name="temperature"> Temperature being returned. </param>
        /// <param name="realFeelTemperature"> RealFeel™ Temperature being returned. </param>
        /// <param name="realFeelTemperatureShade"> RealFeel™ Temperature being returned. Describes what the temperature really feels like in the shade. </param>
        /// <param name="relativeHumidity"> Relative humidity is the amount of water vapor present in air expressed as a percentage of the amount needed for saturation at the same temperature. </param>
        /// <param name="dewPoint"> The dewpoint temperature in specified unit. The dewpoint temperature is the temperature that the air must be cooled to in order to reach saturation. </param>
        /// <param name="wind"> Wind details being returned including speed and direction. </param>
        /// <param name="windGust"> Wind gust. Wind gust is a sudden, brief increase in speed of the wind. </param>
        /// <param name="uvIndex">
        /// Measure of the strength of the ultraviolet radiation from the sun. Supported values are:
        ///   * `0-2` - Low danger from the sun's UV rays or the average person.
        ///   * `3-5` - Moderate risk of harm from unprotected sun exposure.
        ///   * `6-7` - High risk of harm from unprotected sun exposure.
        ///   * `8-10` - Very high risk of harm from unprotected sun exposure.
        ///   * `11+` - Extreme risk of harm from unprotected sun exposure.
        /// </param>
        /// <param name="uvIndexDescription"> Phrase associated with the `uvIndex`. </param>
        /// <param name="visibility"> Visibility in specified unit. A measure of the distance at which an object or light can be clearly discerned. </param>
        /// <param name="obstructionsToVisibility">
        /// Cause of limited visibility.
        ///
        /// Possible values:
        ///
        /// - _A = heavy thunderstorm/hail_
        /// - _BD = blowing dust_
        /// - _BN = blowing sand_
        /// - _BS = blowing snow_
        /// - _D = dust_
        /// - _F = fog_
        /// - _GF = ground fog_
        /// - _HZ = haze_
        /// - _I = ice_
        /// - _IC = ice crystals_
        /// - _IF = ice fog_
        /// - _IP = ice pellets_
        /// - _IPW = ice pellets shower_
        /// - _K = smoke_
        /// - _L = drizzle_
        /// - _R = rain_
        /// - _RS = rain/snow_
        /// - _RW = rain shower_
        /// - _S = snow_
        /// - _SG = snow granules_
        /// - _SP = snow pellets_
        /// - _SW = snow shower_
        /// - _T = thunderstorm_
        /// - _UP = undefined precipitation_
        /// - _ZL = freezing drizzle_
        /// - _ZR = freezing rain_
        /// - _+ = heavy_
        /// - _- = light_
        /// </param>
        /// <param name="cloudCover"> Percent representing cloud cover. </param>
        /// <param name="cloudCeiling"> Cloud ceiling in specified unit. The ceiling is a measurement of the height of the base of the lowest clouds. </param>
        /// <param name="pressure"> Atmospheric pressure in specified unit. </param>
        /// <param name="pressureTendency"> Atmospheric pressure change. </param>
        /// <param name="pastTwentyFourHourTemperatureDeparture"> Departure from the temperature observed 24 hours ago in specified unit. </param>
        /// <param name="apparentTemperature"> Perceived outdoor temperature caused by the combination of air temperature, relative humidity, and wind speed in specified unit. </param>
        /// <param name="windChillTemperature"> Perceived air temperature on exposed skin due to wind. </param>
        /// <param name="wetBulbTemperature"> The temperature to which air may be cooled by evaporating water into it at constant pressure until it reaches saturation. </param>
        /// <param name="precipitationSummary"> Summary of precipitation amounts over the past 24 hours. </param>
        /// <param name="temperatureSummary"> Summary of temperature fluctuations over the past 6, 12, and 24 hours. </param>
        internal CurrentConditions(DateTimeOffset? dateTime, string description, IconCode? iconCode, bool? hasPrecipitation, bool? isDaytime, WeatherValue temperature, WeatherValue realFeelTemperature, WeatherValue realFeelTemperatureShade, int? relativeHumidity, WeatherValue dewPoint, WindDetails wind, WindDetails windGust, int? uvIndex, string uvIndexDescription, WeatherValue visibility, string obstructionsToVisibility, int? cloudCover, WeatherValue cloudCeiling, WeatherValue pressure, PressureTendency pressureTendency, WeatherValue pastTwentyFourHourTemperatureDeparture, WeatherValue apparentTemperature, WeatherValue windChillTemperature, WeatherValue wetBulbTemperature, PrecipitationSummary precipitationSummary, TemperatureSummary temperatureSummary)
        {
            DateTime = dateTime;
            Description = description;
            IconCode = iconCode;
            HasPrecipitation = hasPrecipitation;
            IsDaytime = isDaytime;
            Temperature = temperature;
            RealFeelTemperature = realFeelTemperature;
            RealFeelTemperatureShade = realFeelTemperatureShade;
            RelativeHumidity = relativeHumidity;
            DewPoint = dewPoint;
            Wind = wind;
            WindGust = windGust;
            UvIndex = uvIndex;
            UvIndexDescription = uvIndexDescription;
            Visibility = visibility;
            ObstructionsToVisibility = obstructionsToVisibility;
            CloudCover = cloudCover;
            CloudCeiling = cloudCeiling;
            Pressure = pressure;
            PressureTendency = pressureTendency;
            PastTwentyFourHourTemperatureDeparture = pastTwentyFourHourTemperatureDeparture;
            ApparentTemperature = apparentTemperature;
            WindChillTemperature = windChillTemperature;
            WetBulbTemperature = wetBulbTemperature;
            PrecipitationSummary = precipitationSummary;
            TemperatureSummary = temperatureSummary;
        }

        /// <summary> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </summary>
        public DateTimeOffset? DateTime { get; }
        /// <summary> Phrase description of the current weather condition.  Displayed in specified language. </summary>
        public string Description { get; }
        /// <summary> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </summary>
        public IconCode? IconCode { get; }
        /// <summary> Indicates the presence or absence of precipitation. True indicates the presence of precipitation, false indicates the absence of precipitation. </summary>
        public bool? HasPrecipitation { get; }
        /// <summary> Indicates the time of the day. True indicates 'day',', false indicates 'night. </summary>
        public bool? IsDaytime { get; }
        /// <summary> Temperature being returned. </summary>
        public WeatherValue Temperature { get; }
        /// <summary> RealFeel™ Temperature being returned. </summary>
        public WeatherValue RealFeelTemperature { get; }
        /// <summary> RealFeel™ Temperature being returned. Describes what the temperature really feels like in the shade. </summary>
        public WeatherValue RealFeelTemperatureShade { get; }
        /// <summary> Relative humidity is the amount of water vapor present in air expressed as a percentage of the amount needed for saturation at the same temperature. </summary>
        public int? RelativeHumidity { get; }
        /// <summary> The dewpoint temperature in specified unit. The dewpoint temperature is the temperature that the air must be cooled to in order to reach saturation. </summary>
        public WeatherValue DewPoint { get; }
        /// <summary> Wind details being returned including speed and direction. </summary>
        public WindDetails Wind { get; }
        /// <summary> Wind gust. Wind gust is a sudden, brief increase in speed of the wind. </summary>
        public WindDetails WindGust { get; }
        /// <summary>
        /// Measure of the strength of the ultraviolet radiation from the sun. Supported values are:
        ///   * `0-2` - Low danger from the sun's UV rays or the average person.
        ///   * `3-5` - Moderate risk of harm from unprotected sun exposure.
        ///   * `6-7` - High risk of harm from unprotected sun exposure.
        ///   * `8-10` - Very high risk of harm from unprotected sun exposure.
        ///   * `11+` - Extreme risk of harm from unprotected sun exposure.
        /// </summary>
        public int? UvIndex { get; }
        /// <summary> Phrase associated with the `uvIndex`. </summary>
        public string UvIndexDescription { get; }
        /// <summary> Visibility in specified unit. A measure of the distance at which an object or light can be clearly discerned. </summary>
        public WeatherValue Visibility { get; }
        /// <summary>
        /// Cause of limited visibility.
        ///
        /// Possible values:
        ///
        /// - _A = heavy thunderstorm/hail_
        /// - _BD = blowing dust_
        /// - _BN = blowing sand_
        /// - _BS = blowing snow_
        /// - _D = dust_
        /// - _F = fog_
        /// - _GF = ground fog_
        /// - _HZ = haze_
        /// - _I = ice_
        /// - _IC = ice crystals_
        /// - _IF = ice fog_
        /// - _IP = ice pellets_
        /// - _IPW = ice pellets shower_
        /// - _K = smoke_
        /// - _L = drizzle_
        /// - _R = rain_
        /// - _RS = rain/snow_
        /// - _RW = rain shower_
        /// - _S = snow_
        /// - _SG = snow granules_
        /// - _SP = snow pellets_
        /// - _SW = snow shower_
        /// - _T = thunderstorm_
        /// - _UP = undefined precipitation_
        /// - _ZL = freezing drizzle_
        /// - _ZR = freezing rain_
        /// - _+ = heavy_
        /// - _- = light_
        /// </summary>
        public string ObstructionsToVisibility { get; }
        /// <summary> Percent representing cloud cover. </summary>
        public int? CloudCover { get; }
        /// <summary> Cloud ceiling in specified unit. The ceiling is a measurement of the height of the base of the lowest clouds. </summary>
        public WeatherValue CloudCeiling { get; }
        /// <summary> Atmospheric pressure in specified unit. </summary>
        public WeatherValue Pressure { get; }
        /// <summary> Atmospheric pressure change. </summary>
        public PressureTendency PressureTendency { get; }
        /// <summary> Departure from the temperature observed 24 hours ago in specified unit. </summary>
        public WeatherValue PastTwentyFourHourTemperatureDeparture { get; }
        /// <summary> Perceived outdoor temperature caused by the combination of air temperature, relative humidity, and wind speed in specified unit. </summary>
        public WeatherValue ApparentTemperature { get; }
        /// <summary> Perceived air temperature on exposed skin due to wind. </summary>
        public WeatherValue WindChillTemperature { get; }
        /// <summary> The temperature to which air may be cooled by evaporating water into it at constant pressure until it reaches saturation. </summary>
        public WeatherValue WetBulbTemperature { get; }
        /// <summary> Summary of precipitation amounts over the past 24 hours. </summary>
        public PrecipitationSummary PrecipitationSummary { get; }
        /// <summary> Summary of temperature fluctuations over the past 6, 12, and 24 hours. </summary>
        public TemperatureSummary TemperatureSummary { get; }
    }
}
