// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class CurrentConditions
    {
        internal static CurrentConditions DeserializeCurrentConditions(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? dateTime = default;
            string phrase = default;
            IconCode? iconCode = default;
            bool? hasPrecipitation = default;
            bool? isDayTime = default;
            WeatherValue temperature = default;
            WeatherValue realFeelTemperature = default;
            WeatherValue realFeelTemperatureShade = default;
            int? relativeHumidity = default;
            WeatherValue dewPoint = default;
            WindDetails wind = default;
            WindDetails windGust = default;
            int? uvIndex = default;
            string uvIndexPhrase = default;
            WeatherValue visibility = default;
            string obstructionsToVisibility = default;
            int? cloudCover = default;
            WeatherValue ceiling = default;
            WeatherValue pressure = default;
            PressureTendency pressureTendency = default;
            WeatherValue pastTwentyFourHourTemperatureDeparture = default;
            WeatherValue apparentTemperature = default;
            WeatherValue windChillTemperature = default;
            WeatherValue wetBulbTemperature = default;
            PrecipitationSummary precipitationSummary = default;
            TemperatureSummary temperatureSummary = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("dateTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dateTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("phrase"u8))
                {
                    phrase = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("iconCode"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    iconCode = new IconCode(property.Value.GetInt32());
                    continue;
                }
                if (property.NameEquals("hasPrecipitation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hasPrecipitation = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("isDayTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isDayTime = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("temperature"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    temperature = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("realFeelTemperature"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    realFeelTemperature = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("realFeelTemperatureShade"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    realFeelTemperatureShade = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("relativeHumidity"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    relativeHumidity = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("dewPoint"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dewPoint = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("wind"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    wind = WindDetails.DeserializeWindDetails(property.Value);
                    continue;
                }
                if (property.NameEquals("windGust"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    windGust = WindDetails.DeserializeWindDetails(property.Value);
                    continue;
                }
                if (property.NameEquals("uvIndex"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    uvIndex = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("uvIndexPhrase"u8))
                {
                    uvIndexPhrase = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("visibility"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    visibility = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("obstructionsToVisibility"u8))
                {
                    obstructionsToVisibility = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("cloudCover"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cloudCover = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("ceiling"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    ceiling = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("pressure"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pressure = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("pressureTendency"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pressureTendency = PressureTendency.DeserializePressureTendency(property.Value);
                    continue;
                }
                if (property.NameEquals("pastTwentyFourHourTemperatureDeparture"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    pastTwentyFourHourTemperatureDeparture = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("apparentTemperature"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    apparentTemperature = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("windChillTemperature"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    windChillTemperature = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("wetBulbTemperature"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    wetBulbTemperature = WeatherValue.DeserializeWeatherValue(property.Value);
                    continue;
                }
                if (property.NameEquals("precipitationSummary"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    precipitationSummary = PrecipitationSummary.DeserializePrecipitationSummary(property.Value);
                    continue;
                }
                if (property.NameEquals("temperatureSummary"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    temperatureSummary = TemperatureSummary.DeserializeTemperatureSummary(property.Value);
                    continue;
                }
            }
            return new CurrentConditions(
                dateTime,
                phrase,
                iconCode,
                hasPrecipitation,
                isDayTime,
                temperature,
                realFeelTemperature,
                realFeelTemperatureShade,
                relativeHumidity,
                dewPoint,
                wind,
                windGust,
                uvIndex,
                uvIndexPhrase,
                visibility,
                obstructionsToVisibility,
                cloudCover,
                ceiling,
                pressure,
                pressureTendency,
                pastTwentyFourHourTemperatureDeparture,
                apparentTemperature,
                windChillTemperature,
                wetBulbTemperature,
                precipitationSummary,
                temperatureSummary);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static CurrentConditions FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeCurrentConditions(document.RootElement);
        }
    }
}
