// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Weather.Models
{
    /// <summary> The BasinId. </summary>
    public readonly partial struct BasinId : IEquatable<BasinId>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BasinId"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BasinId(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ALValue = "AL";
        private const string EPValue = "EP";
        private const string SIValue = "SI";
        private const string NIValue = "NI";
        private const string CPValue = "CP";
        private const string NPValue = "NP";
        private const string SPValue = "SP";

        /// <summary> Atlantic. </summary>
        public static BasinId AL { get; } = new BasinId(ALValue);
        /// <summary> Eastern Pacific. </summary>
        public static BasinId EP { get; } = new BasinId(EPValue);
        /// <summary> Southwest Indian Ocean. </summary>
        public static BasinId SI { get; } = new BasinId(SIValue);
        /// <summary> North Indian Ocean. </summary>
        public static BasinId NI { get; } = new BasinId(NIValue);
        /// <summary> Central Pacific. </summary>
        public static BasinId CP { get; } = new BasinId(CPValue);
        /// <summary> Northwest Pacific. </summary>
        public static BasinId NP { get; } = new BasinId(NPValue);
        /// <summary> South Pacific. </summary>
        public static BasinId SP { get; } = new BasinId(SPValue);
        /// <summary> Determines if two <see cref="BasinId"/> values are the same. </summary>
        public static bool operator ==(BasinId left, BasinId right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BasinId"/> values are not the same. </summary>
        public static bool operator !=(BasinId left, BasinId right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BasinId"/>. </summary>
        public static implicit operator BasinId(string value) => new BasinId(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BasinId other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BasinId other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
