// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Maps.Weather.Models
{
    /// <summary> Information about a severe weather alert issued within an affected area(s). If multiple alerts are active for the same location, the alerts will be returned in order of `priority` within the API response, with the highest priority alert being returned at the top of the response. </summary>
    public partial class AlertDetails
    {
        /// <summary> Initializes a new instance of <see cref="AlertDetails"/>. </summary>
        internal AlertDetails()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AlertDetails"/>. </summary>
        /// <param name="name"> The name of an area which is affected by the alert. The location that was requested falls under the alert area. </param>
        /// <param name="description"> Text summarizing the alert in the returned area. </param>
        /// <param name="startTime"> The start date and time of the alert in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. If the alert crosses multiple time zones the returned time in the response is the local time to the requested coordinate location. </param>
        /// <param name="endTime"> The end date and time of the alert in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. If the alert crosses multiple time zones the returned time in the response is the local time to the requested coordinate location. </param>
        /// <param name="latestStatus"> The latest status of the alert in the current area. </param>
        /// <param name="details"> Full details associated with the alert. Returned if `details`=True. This field is always returned in the language(s) of choice by the issuing provider and Azure Maps only returns what is created by the provider. Please note, some countries/regions may offer their native language and English. Language parameter won’t apply to this field. </param>
        /// <param name="language"> Language of the `alertDetails`. This field  helps to point out that the language of the `alertDetails` may differ from the requested language parameter. Returned if `details`=True. Language code has been derived from the ISO 639-1 Alpha-2 codes. </param>
        internal AlertDetails(string name, string description, DateTimeOffset? startTime, DateTimeOffset? endTime, LatestStatus latestStatus, string details, string language)
        {
            Name = name;
            Description = description;
            StartTime = startTime;
            EndTime = endTime;
            LatestStatus = latestStatus;
            Details = details;
            Language = language;
        }

        /// <summary> The name of an area which is affected by the alert. The location that was requested falls under the alert area. </summary>
        public string Name { get; }
        /// <summary> Text summarizing the alert in the returned area. </summary>
        public string Description { get; }
        /// <summary> The start date and time of the alert in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. If the alert crosses multiple time zones the returned time in the response is the local time to the requested coordinate location. </summary>
        public DateTimeOffset? StartTime { get; }
        /// <summary> The end date and time of the alert in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. If the alert crosses multiple time zones the returned time in the response is the local time to the requested coordinate location. </summary>
        public DateTimeOffset? EndTime { get; }
        /// <summary> The latest status of the alert in the current area. </summary>
        public LatestStatus LatestStatus { get; }
        /// <summary> Full details associated with the alert. Returned if `details`=True. This field is always returned in the language(s) of choice by the issuing provider and Azure Maps only returns what is created by the provider. Please note, some countries/regions may offer their native language and English. Language parameter won’t apply to this field. </summary>
        public string Details { get; }
        /// <summary> Language of the `alertDetails`. This field  helps to point out that the language of the `alertDetails` may differ from the requested language parameter. Returned if `details`=True. Language code has been derived from the ISO 639-1 Alpha-2 codes. </summary>
        public string Language { get; }
    }
}
