// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    public partial class AlertDetails
    {
        internal static AlertDetails DeserializeAlertDetails(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string name = default;
            string summary = default;
            DateTimeOffset? startTime = default;
            DateTimeOffset? endTime = default;
            LatestStatus latestStatus = default;
            string alertDetails = default;
            string alertDetailsLanguageCode = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("summary"u8))
                {
                    summary = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("startTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    startTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("endTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    endTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("latestStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    latestStatus = LatestStatus.DeserializeLatestStatus(property.Value);
                    continue;
                }
                if (property.NameEquals("alertDetails"u8))
                {
                    alertDetails = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("alertDetailsLanguageCode"u8))
                {
                    alertDetailsLanguageCode = property.Value.GetString();
                    continue;
                }
            }
            return new AlertDetails(
                name,
                summary,
                startTime,
                endTime,
                latestStatus,
                alertDetails,
                alertDetailsLanguageCode);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static AlertDetails FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeAlertDetails(document.RootElement);
        }
    }
}
