// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    /// <summary> This object is returned from a successful Get Air Quality call. </summary>
    public partial class AirQualityResult
    {
        /// <summary> Initializes a new instance of <see cref="AirQualityResult"/>. </summary>
        internal AirQualityResult()
        {
            AirQualityResults = new ChangeTrackingList<AirQuality>();
        }

        /// <summary> Initializes a new instance of <see cref="AirQualityResult"/>. </summary>
        /// <param name="airQualityResults"> A list of all air quality results for the queried location. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        internal AirQualityResult(IReadOnlyList<AirQuality> airQualityResults, string nextLink)
        {
            AirQualityResults = airQualityResults;
            NextLink = nextLink;
        }

        /// <summary> A list of all air quality results for the queried location. </summary>
        public IReadOnlyList<AirQuality> AirQualityResults { get; }
        /// <summary> The is the link to the next page of the features returned. If it's the last page, no this field. </summary>
        public string NextLink { get; }
    }
}
