// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

namespace Azure.Maps.Weather.Models
{
    /// <summary> The AirAndPollen. </summary>
    public partial class AirAndPollen
    {
        /// <summary> Initializes a new instance of <see cref="AirAndPollen"/>. </summary>
        internal AirAndPollen()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AirAndPollen"/>. </summary>
        /// <param name="description"> Name of the pollen or pollutant. For example, grass, mold, weed, air quality, tree and UV index. </param>
        /// <param name="value"> Value of the given type above. Values associated with mold, grass, weed and tree are in units of parts per cubic meter. Both air quality and UV are indices, so they are unitless. </param>
        /// <param name="category"> Category of the air quality or pollution type. For example, low, high, good, moderate, unhealthy, hazardous. </param>
        /// <param name="categoryValue"> Value associated with the air quality or pollution category. These values range from 1 to 6. 1 implying good conditions, 6 implying hazardous conditions. </param>
        /// <param name="airQualityType"> Only exists for air quality. Examples include ozone and particle pollution. </param>
        internal AirAndPollen(string description, int? value, string category, int? categoryValue, string airQualityType)
        {
            Description = description;
            Value = value;
            Category = category;
            CategoryValue = categoryValue;
            AirQualityType = airQualityType;
        }

        /// <summary> Name of the pollen or pollutant. For example, grass, mold, weed, air quality, tree and UV index. </summary>
        public string Description { get; }
        /// <summary> Value of the given type above. Values associated with mold, grass, weed and tree are in units of parts per cubic meter. Both air quality and UV are indices, so they are unitless. </summary>
        public int? Value { get; }
        /// <summary> Category of the air quality or pollution type. For example, low, high, good, moderate, unhealthy, hazardous. </summary>
        public string Category { get; }
        /// <summary> Value associated with the air quality or pollution category. These values range from 1 to 6. 1 implying good conditions, 6 implying hazardous conditions. </summary>
        public int? CategoryValue { get; }
        /// <summary> Only exists for air quality. Examples include ozone and particle pollution. </summary>
        public string AirQualityType { get; }
    }
}
