// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Weather.Models
{
    /// <summary> All government-issued active storms. </summary>
    public partial class ActiveStormResult
    {
        /// <summary> Initializes a new instance of <see cref="ActiveStormResult"/>. </summary>
        internal ActiveStormResult()
        {
            ActiveStorms = new ChangeTrackingList<ActiveStorm>();
        }

        /// <summary> Initializes a new instance of <see cref="ActiveStormResult"/>. </summary>
        /// <param name="activeStorms"> All government-issued active storms. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        internal ActiveStormResult(IReadOnlyList<ActiveStorm> activeStorms, string nextLink)
        {
            ActiveStorms = activeStorms;
            NextLink = nextLink;
        }

        /// <summary> All government-issued active storms. </summary>
        public IReadOnlyList<ActiveStorm> ActiveStorms { get; }
        /// <summary> The is the link to the next page of the features returned. If it's the last page, no this field. </summary>
        public string NextLink { get; }
    }
}
