// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core.GeoJson;

namespace Azure.Maps.Weather.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class MapsWeatherModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.HourlyForecastResult"/>. </summary>
        /// <param name="forecasts"> Forecast data for each returned hour. </param>
        /// <returns> A new <see cref="Models.HourlyForecastResult"/> instance for mocking. </returns>
        public static HourlyForecastResult HourlyForecastResult(IEnumerable<HourlyForecast> forecasts = null)
        {
            forecasts ??= new List<HourlyForecast>();

            return new HourlyForecastResult(forecasts?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.HourlyForecast"/>. </summary>
        /// <param name="timestamp"> Date and time of the forecast in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="iconCode"> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </param>
        /// <param name="iconPhrase"> Phrase description of the weather icon. </param>
        /// <param name="hasPrecipitation"> Indicates the presence or absence of precipitation. True indicates the presence of precipitation, false indicates the absence of precipitation. </param>
        /// <param name="isDaylight"> Specifies whether or not it is daylight. True indicates day light. </param>
        /// <param name="temperature"> Temperature being returned. </param>
        /// <param name="realFeelTemperature"> RealFeel™ Temperature being returned. Describes what the temperature really feels like in the shade. </param>
        /// <param name="wetBulbTemperature"> The temperature to which air may be cooled by evaporating water into it at constant pressure until it reaches saturation. </param>
        /// <param name="dewPoint"> The dewpoint temperature in specified unit. The dewpoint temperature is the temperature that the air must be cooled to in order to reach saturation. </param>
        /// <param name="wind"> Wind details being returned including speed and direction. </param>
        /// <param name="windGust"> Wind gust. Wind gust is a sudden, brief increase in speed of the wind. </param>
        /// <param name="relativeHumidity"> Relative humidity is the amount of water vapor present in air expressed as a percentage of the amount needed for saturation at the same temperature. </param>
        /// <param name="visibility"> Visibility in specified unit. A measure of the distance at which an object or light can be clearly discerned. </param>
        /// <param name="cloudCeiling"> Cloud ceiling in specified unit. The ceiling is a measurement of the height of the base of the lowest clouds. </param>
        /// <param name="uvIndex">
        /// Measure of the strength of the ultraviolet radiation from the sun. Supported values are:
        ///   * `0-2` - Low danger from the sun's UV rays or the average person.
        ///   * `3-5` - Moderate risk of harm from unprotected sun exposure.
        ///   * `6-7` - High risk of harm from unprotected sun exposure.
        ///   * `8-10` - Very high risk of harm from unprotected sun exposure.
        ///   * `11+` - Extreme risk of harm from unprotected sun exposure.
        /// </param>
        /// <param name="uvIndexDescription"> Phrase associated with the `uvIndex`. </param>
        /// <param name="precipitationProbability"> Percent representing the probability of precipitation. For example, '20'. </param>
        /// <param name="rainProbability"> Percent representing the probability of rain. For example, '50'. </param>
        /// <param name="snowProbability"> Percent representing the probability of snow. For example, '50'. </param>
        /// <param name="iceProbability"> Percent representing the probability of snow. For example, '5'. </param>
        /// <param name="totalLiquid"> Total liquid equivalent of precipitation during the forecast period. </param>
        /// <param name="rain"> Rain. </param>
        /// <param name="snow"> Snow. </param>
        /// <param name="ice"> Ice. </param>
        /// <param name="cloudCover"> Percent representing cloud cover. </param>
        /// <returns> A new <see cref="Models.HourlyForecast"/> instance for mocking. </returns>
        public static HourlyForecast HourlyForecast(DateTimeOffset? timestamp = null, IconCode? iconCode = null, string iconPhrase = null, bool? hasPrecipitation = null, bool? isDaylight = null, WeatherValue temperature = null, WeatherValue realFeelTemperature = null, WeatherValue wetBulbTemperature = null, WeatherValue dewPoint = null, WindDetails wind = null, WindDetails windGust = null, int? relativeHumidity = null, WeatherValue visibility = null, WeatherValue cloudCeiling = null, int? uvIndex = null, string uvIndexDescription = null, int? precipitationProbability = null, int? rainProbability = null, int? snowProbability = null, int? iceProbability = null, WeatherValue totalLiquid = null, WeatherValue rain = null, WeatherValue snow = null, WeatherValue ice = null, int? cloudCover = null)
        {
            return new HourlyForecast(
                timestamp,
                iconCode,
                iconPhrase,
                hasPrecipitation,
                isDaylight,
                temperature,
                realFeelTemperature,
                wetBulbTemperature,
                dewPoint,
                wind,
                windGust,
                relativeHumidity,
                visibility,
                cloudCeiling,
                uvIndex,
                uvIndexDescription,
                precipitationProbability,
                rainProbability,
                snowProbability,
                iceProbability,
                totalLiquid,
                rain,
                snow,
                ice,
                cloudCover);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WeatherValue"/>. </summary>
        /// <param name="value"> Rounded value. </param>
        /// <param name="unitLabel"> Type of unit for the returned value. </param>
        /// <param name="unitType"> Numeric ID value associated with the type of unit being displayed. Can be used for unit translation. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#unittype) for details. </param>
        /// <returns> A new <see cref="Models.WeatherValue"/> instance for mocking. </returns>
        public static WeatherValue WeatherValue(float? value = null, string unitLabel = null, UnitType? unitType = null)
        {
            return new WeatherValue(value, unitLabel, unitType);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WindDetails"/>. </summary>
        /// <param name="direction"> Wind direction. </param>
        /// <param name="speed"> Speed of the wind in specified unit. </param>
        /// <returns> A new <see cref="Models.WindDetails"/> instance for mocking. </returns>
        public static WindDetails WindDetails(WindDirection direction = null, WeatherValue speed = null)
        {
            return new WindDetails(direction, speed);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WindDirection"/>. </summary>
        /// <param name="degrees"> Wind direction in Azimuth degrees,  starting at true North and continuing in clockwise direction. North is 0 degrees, east is 90 degrees, south is 180 degrees, west is 270 degrees. Possible values 0-359. </param>
        /// <param name="description"> Direction abbreviation in the specified language. </param>
        /// <returns> A new <see cref="Models.WindDirection"/> instance for mocking. </returns>
        public static WindDirection WindDirection(int? degrees = null, string description = null)
        {
            return new WindDirection(degrees, description);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MinuteForecastResult"/>. </summary>
        /// <param name="summary"> Phrase summaries for the entire forecast period. </param>
        /// <param name="intervalSummaries"> Summary information for each interval in the forecast. The Summaries breaks down each potential interval where precipitation starts and stops. </param>
        /// <param name="intervals"> Forecast data for each interval in the forecast. </param>
        /// <returns> A new <see cref="Models.MinuteForecastResult"/> instance for mocking. </returns>
        public static MinuteForecastResult MinuteForecastResult(MinuteForecastSummary summary = null, IEnumerable<IntervalSummary> intervalSummaries = null, IEnumerable<ForecastInterval> intervals = null)
        {
            intervalSummaries ??= new List<IntervalSummary>();
            intervals ??= new List<ForecastInterval>();

            return new MinuteForecastResult(summary, intervalSummaries?.ToList(), intervals?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MinuteForecastSummary"/>. </summary>
        /// <param name="briefPhrase60"> Summary phrase for the next 60 minutes. Phrase length is approximately 60 characters. </param>
        /// <param name="shortDescription"> Short summary phrase for the next 120 minutes. Phrase length is approximately 25 characters. </param>
        /// <param name="briefDescription"> Summary phrase for the next 120 minutes. Phrase length is approximately 60 characters. </param>
        /// <param name="longPhrase"> Long summary phrase for the next 120 minutes. Phrase length is 60+ characters. </param>
        /// <param name="iconCode"> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </param>
        /// <returns> A new <see cref="Models.MinuteForecastSummary"/> instance for mocking. </returns>
        public static MinuteForecastSummary MinuteForecastSummary(string briefPhrase60 = null, string shortDescription = null, string briefDescription = null, string longPhrase = null, IconCode? iconCode = null)
        {
            return new MinuteForecastSummary(briefPhrase60, shortDescription, briefDescription, longPhrase, iconCode);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntervalSummary"/>. </summary>
        /// <param name="startMinute"> The first minute to which the summary applies. </param>
        /// <param name="endMinute"> The last minute to which the summary applies. </param>
        /// <param name="totalMinutes"> The number of minutes for which the summary applies. </param>
        /// <param name="shortDescription"> Short summary phrase. Phrase length is approximately 25 characters. </param>
        /// <param name="briefDescription"> Brief summary phrase. Phrase length is approximately 60 characters. </param>
        /// <param name="longPhrase"> Long summary phrase. Phrase length is 60+ characters. </param>
        /// <param name="iconCode"> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </param>
        /// <returns> A new <see cref="Models.IntervalSummary"/> instance for mocking. </returns>
        public static IntervalSummary IntervalSummary(int? startMinute = null, int? endMinute = null, int? totalMinutes = null, string shortDescription = null, string briefDescription = null, string longPhrase = null, IconCode? iconCode = null)
        {
            return new IntervalSummary(
                startMinute,
                endMinute,
                totalMinutes,
                shortDescription,
                briefDescription,
                longPhrase,
                iconCode);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ForecastInterval"/>. </summary>
        /// <param name="startTime"> The date and time for the start of the interval in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="minute"> The first minute for the interval. </param>
        /// <param name="decibelRelativeToZ"> A unit that represents forecasted precipitation intensity. </param>
        /// <param name="shortDescription"> A short phrase describing precipitation condition for the interval. </param>
        /// <param name="threshold"> Key that specifies the threshold value. Along with precipitationType, can be used to determine the simplifiedColor. If dbz is zero, not present in the response. </param>
        /// <param name="color"> The full spectrum color that maps to the dBZ (decibel relative to Z). If dbz is zero, color is not present in the response. </param>
        /// <param name="simplifiedColor"> The band color that maps to the precipitation type and threshold. If dbz is zero, not present in the response. </param>
        /// <param name="precipitationType"> Specifies the type of precipitation ("Rain" "Snow" "Ice" or "Mix"). If dbz is zero, precipitationType is not present in the response. </param>
        /// <param name="iconCode"> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </param>
        /// <param name="cloudCover"> Percent representing cloud cover. </param>
        /// <returns> A new <see cref="Models.ForecastInterval"/> instance for mocking. </returns>
        public static ForecastInterval ForecastInterval(DateTimeOffset? startTime = null, int? minute = null, double? decibelRelativeToZ = null, string shortDescription = null, string threshold = null, ColorValue color = null, ColorValue simplifiedColor = null, PrecipitationType? precipitationType = null, IconCode? iconCode = null, int? cloudCover = null)
        {
            return new ForecastInterval(
                startTime,
                minute,
                decibelRelativeToZ,
                shortDescription,
                threshold,
                color,
                simplifiedColor,
                precipitationType,
                iconCode,
                cloudCover);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ColorValue"/>. </summary>
        /// <param name="red"> Red component of the RGB value. </param>
        /// <param name="green"> Green component of the RGB value. </param>
        /// <param name="blue"> Blue component of the RGB value. </param>
        /// <param name="hex"> Hexadecimal color value. </param>
        /// <returns> A new <see cref="Models.ColorValue"/> instance for mocking. </returns>
        public static ColorValue ColorValue(int? red = null, int? green = null, int? blue = null, string hex = null)
        {
            return new ColorValue(red, green, blue, hex);
        }

        /// <summary> Initializes a new instance of <see cref="Models.QuarterDayForecastResult"/>. </summary>
        /// <param name="forecasts"> Forecast data for each quarter in the response. </param>
        /// <returns> A new <see cref="Models.QuarterDayForecastResult"/> instance for mocking. </returns>
        public static QuarterDayForecastResult QuarterDayForecastResult(IEnumerable<QuarterDayForecast> forecasts = null)
        {
            forecasts ??= new List<QuarterDayForecast>();

            return new QuarterDayForecastResult(forecasts?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.QuarterDayForecast"/>. </summary>
        /// <param name="dateTime"> Date of the forecast as example, 2019-10-27T00:00:00. </param>
        /// <param name="effectiveDate"> Date and time of the beginning of the forecast quarter displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="quarter"> Quarter of the day. </param>
        /// <param name="iconCode"> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </param>
        /// <param name="iconPhrase"> Phrase description of the icon. Displayed in specified language. For example, 'Sunny'. </param>
        /// <param name="phrase"> Short summary phrase summary for quarter. </param>
        /// <param name="temperature"> Temperature values for the quarter. </param>
        /// <param name="realFeelTemperature"> RealFeel™ Temperature values for the quarter. </param>
        /// <param name="dewPoint"> The dewpoint temperature in specified unit. The dewpoint temperature is the temperature that the air must be cooled to in order to reach saturation. </param>
        /// <param name="relativeHumidity"> Relative humidity is the amount of water vapor present in air expressed as a percentage of the amount needed for saturation at the same temperature. </param>
        /// <param name="wind"> Wind details being returned including speed and direction. </param>
        /// <param name="windGust"> Wind gust. Wind gust is a sudden, brief increase in speed of the wind. </param>
        /// <param name="visibility"> Visibility in specified unit. A measure of the distance at which an object or light can be clearly discerned. </param>
        /// <param name="cloudCover"> Percent representing cloud cover. </param>
        /// <param name="hasPrecipitation"> Indicates the presence or absence of precipitation. True indicates the presence of precipitation, false indicates the absence of precipitation. </param>
        /// <param name="precipitationType"> Specifies the type of precipitation ("Rain" "Snow" "Ice" or "Mix"). If dbz is zero, precipitationType is not present in the response. </param>
        /// <param name="precipitationIntensity"> Description of the intensity. </param>
        /// <param name="precipitationProbability"> Percent representing the probability of precipitation. For example, '20'. </param>
        /// <param name="thunderstormProbability"> Percent representing the probability of a thunderstorm. For example, '10'. </param>
        /// <param name="totalLiquid"> Total liquid equivalent of precipitation during the forecast period. </param>
        /// <param name="rain"> Rain. </param>
        /// <param name="snow"> Snow. </param>
        /// <param name="ice"> Ice. </param>
        /// <returns> A new <see cref="Models.QuarterDayForecast"/> instance for mocking. </returns>
        public static QuarterDayForecast QuarterDayForecast(DateTimeOffset? dateTime = null, DateTimeOffset? effectiveDate = null, DayQuarter? quarter = null, IconCode? iconCode = null, string iconPhrase = null, string phrase = null, WeatherValueRange temperature = null, WeatherValueRange realFeelTemperature = null, WeatherValue dewPoint = null, int? relativeHumidity = null, WindDetails wind = null, WindDetails windGust = null, WeatherValue visibility = null, int? cloudCover = null, bool? hasPrecipitation = null, PrecipitationType? precipitationType = null, string precipitationIntensity = null, int? precipitationProbability = null, int? thunderstormProbability = null, WeatherValue totalLiquid = null, WeatherValue rain = null, WeatherValue snow = null, WeatherValue ice = null)
        {
            return new QuarterDayForecast(
                dateTime,
                effectiveDate,
                quarter,
                iconCode,
                iconPhrase,
                phrase,
                temperature,
                realFeelTemperature,
                dewPoint,
                relativeHumidity,
                wind,
                windGust,
                visibility,
                cloudCover,
                hasPrecipitation,
                precipitationType,
                precipitationIntensity,
                precipitationProbability,
                thunderstormProbability,
                totalLiquid,
                rain,
                snow,
                ice);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WeatherValueRange"/>. </summary>
        /// <param name="minimum"> Minimum temperature for the time period. </param>
        /// <param name="maximum"> Maximum temperature for the time period. </param>
        /// <returns> A new <see cref="Models.WeatherValueRange"/> instance for mocking. </returns>
        public static WeatherValueRange WeatherValueRange(WeatherValue minimum = null, WeatherValue maximum = null)
        {
            return new WeatherValueRange(minimum, maximum);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CurrentConditionsResult"/>. </summary>
        /// <param name="results"> Detailed current weather conditions. </param>
        /// <returns> A new <see cref="Models.CurrentConditionsResult"/> instance for mocking. </returns>
        public static CurrentConditionsResult CurrentConditionsResult(IEnumerable<CurrentConditions> results = null)
        {
            results ??= new List<CurrentConditions>();

            return new CurrentConditionsResult(results?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.CurrentConditions"/>. </summary>
        /// <param name="dateTime"> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="description"> Phrase description of the current weather condition.  Displayed in specified language. </param>
        /// <param name="iconCode"> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </param>
        /// <param name="hasPrecipitation"> Indicates the presence or absence of precipitation. True indicates the presence of precipitation, false indicates the absence of precipitation. </param>
        /// <param name="isDaytime"> Indicates the time of the day. True indicates 'day',', false indicates 'night. </param>
        /// <param name="temperature"> Temperature being returned. </param>
        /// <param name="realFeelTemperature"> RealFeel™ Temperature being returned. </param>
        /// <param name="realFeelTemperatureShade"> RealFeel™ Temperature being returned. Describes what the temperature really feels like in the shade. </param>
        /// <param name="relativeHumidity"> Relative humidity is the amount of water vapor present in air expressed as a percentage of the amount needed for saturation at the same temperature. </param>
        /// <param name="dewPoint"> The dewpoint temperature in specified unit. The dewpoint temperature is the temperature that the air must be cooled to in order to reach saturation. </param>
        /// <param name="wind"> Wind details being returned including speed and direction. </param>
        /// <param name="windGust"> Wind gust. Wind gust is a sudden, brief increase in speed of the wind. </param>
        /// <param name="uvIndex">
        /// Measure of the strength of the ultraviolet radiation from the sun. Supported values are:
        ///   * `0-2` - Low danger from the sun's UV rays or the average person.
        ///   * `3-5` - Moderate risk of harm from unprotected sun exposure.
        ///   * `6-7` - High risk of harm from unprotected sun exposure.
        ///   * `8-10` - Very high risk of harm from unprotected sun exposure.
        ///   * `11+` - Extreme risk of harm from unprotected sun exposure.
        /// </param>
        /// <param name="uvIndexDescription"> Phrase associated with the `uvIndex`. </param>
        /// <param name="visibility"> Visibility in specified unit. A measure of the distance at which an object or light can be clearly discerned. </param>
        /// <param name="obstructionsToVisibility">
        /// Cause of limited visibility.
        ///
        /// Possible values:
        ///
        /// - _A = heavy thunderstorm/hail_
        /// - _BD = blowing dust_
        /// - _BN = blowing sand_
        /// - _BS = blowing snow_
        /// - _D = dust_
        /// - _F = fog_
        /// - _GF = ground fog_
        /// - _HZ = haze_
        /// - _I = ice_
        /// - _IC = ice crystals_
        /// - _IF = ice fog_
        /// - _IP = ice pellets_
        /// - _IPW = ice pellets shower_
        /// - _K = smoke_
        /// - _L = drizzle_
        /// - _R = rain_
        /// - _RS = rain/snow_
        /// - _RW = rain shower_
        /// - _S = snow_
        /// - _SG = snow granules_
        /// - _SP = snow pellets_
        /// - _SW = snow shower_
        /// - _T = thunderstorm_
        /// - _UP = undefined precipitation_
        /// - _ZL = freezing drizzle_
        /// - _ZR = freezing rain_
        /// - _+ = heavy_
        /// - _- = light_
        /// </param>
        /// <param name="cloudCover"> Percent representing cloud cover. </param>
        /// <param name="cloudCeiling"> Cloud ceiling in specified unit. The ceiling is a measurement of the height of the base of the lowest clouds. </param>
        /// <param name="pressure"> Atmospheric pressure in specified unit. </param>
        /// <param name="pressureTendency"> Atmospheric pressure change. </param>
        /// <param name="pastTwentyFourHourTemperatureDeparture"> Departure from the temperature observed 24 hours ago in specified unit. </param>
        /// <param name="apparentTemperature"> Perceived outdoor temperature caused by the combination of air temperature, relative humidity, and wind speed in specified unit. </param>
        /// <param name="windChillTemperature"> Perceived air temperature on exposed skin due to wind. </param>
        /// <param name="wetBulbTemperature"> The temperature to which air may be cooled by evaporating water into it at constant pressure until it reaches saturation. </param>
        /// <param name="precipitationSummary"> Summary of precipitation amounts over the past 24 hours. </param>
        /// <param name="temperatureSummary"> Summary of temperature fluctuations over the past 6, 12, and 24 hours. </param>
        /// <returns> A new <see cref="Models.CurrentConditions"/> instance for mocking. </returns>
        public static CurrentConditions CurrentConditions(DateTimeOffset? dateTime = null, string description = null, IconCode? iconCode = null, bool? hasPrecipitation = null, bool? isDaytime = null, WeatherValue temperature = null, WeatherValue realFeelTemperature = null, WeatherValue realFeelTemperatureShade = null, int? relativeHumidity = null, WeatherValue dewPoint = null, WindDetails wind = null, WindDetails windGust = null, int? uvIndex = null, string uvIndexDescription = null, WeatherValue visibility = null, string obstructionsToVisibility = null, int? cloudCover = null, WeatherValue cloudCeiling = null, WeatherValue pressure = null, PressureTendency pressureTendency = null, WeatherValue pastTwentyFourHourTemperatureDeparture = null, WeatherValue apparentTemperature = null, WeatherValue windChillTemperature = null, WeatherValue wetBulbTemperature = null, PrecipitationSummary precipitationSummary = null, TemperatureSummary temperatureSummary = null)
        {
            return new CurrentConditions(
                dateTime,
                description,
                iconCode,
                hasPrecipitation,
                isDaytime,
                temperature,
                realFeelTemperature,
                realFeelTemperatureShade,
                relativeHumidity,
                dewPoint,
                wind,
                windGust,
                uvIndex,
                uvIndexDescription,
                visibility,
                obstructionsToVisibility,
                cloudCover,
                cloudCeiling,
                pressure,
                pressureTendency,
                pastTwentyFourHourTemperatureDeparture,
                apparentTemperature,
                windChillTemperature,
                wetBulbTemperature,
                precipitationSummary,
                temperatureSummary);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PressureTendency"/>. </summary>
        /// <param name="description"> Description of the pressure tendency in specified language. </param>
        /// <param name="code"> Pressure tendency code regardless of language. One of F=Falling, S=Steady, R=Rising. </param>
        /// <returns> A new <see cref="Models.PressureTendency"/> instance for mocking. </returns>
        public static PressureTendency PressureTendency(string description = null, string code = null)
        {
            return new PressureTendency(description, code);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PrecipitationSummary"/>. </summary>
        /// <param name="pastHour"> The amount of precipitation (liquid equivalent) that has fallen in the past hour. </param>
        /// <param name="pastThreeHours"> The amount of precipitation (liquid equivalent) that has fallen in the past three hours. </param>
        /// <param name="pastSixHours"> The amount of precipitation (liquid equivalent) that has fallen in the past six hours. Contains Metric and Imperial Values. </param>
        /// <param name="pastNineHours"> The amount of precipitation (liquid equivalent) that has fallen in the past nine hours. </param>
        /// <param name="pastTwelveHours"> The amount of precipitation (liquid equivalent) that has fallen in the past 12 hours. </param>
        /// <param name="pastEighteenHours"> The amount of precipitation (liquid equivalent) that has fallen in the past 18 hours. </param>
        /// <param name="pastTwentyFourHours"> The amount of precipitation (liquid equivalent) that has fallen in the past 24 hours. </param>
        /// <returns> A new <see cref="Models.PrecipitationSummary"/> instance for mocking. </returns>
        public static PrecipitationSummary PrecipitationSummary(WeatherValue pastHour = null, WeatherValue pastThreeHours = null, WeatherValue pastSixHours = null, WeatherValue pastNineHours = null, WeatherValue pastTwelveHours = null, WeatherValue pastEighteenHours = null, WeatherValue pastTwentyFourHours = null)
        {
            return new PrecipitationSummary(
                pastHour,
                pastThreeHours,
                pastSixHours,
                pastNineHours,
                pastTwelveHours,
                pastEighteenHours,
                pastTwentyFourHours);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TemperatureSummary"/>. </summary>
        /// <param name="pastSixHours"> Summary of temperature fluctuations over the past 6 hours. </param>
        /// <param name="pastTwelveHours"> Summary of temperature fluctuations over the past 12 hours. </param>
        /// <param name="pastTwentyFourHours"> Summary of temperature fluctuations over the past 24 hours. </param>
        /// <returns> A new <see cref="Models.TemperatureSummary"/> instance for mocking. </returns>
        public static TemperatureSummary TemperatureSummary(PastHoursTemperature pastSixHours = null, PastHoursTemperature pastTwelveHours = null, PastHoursTemperature pastTwentyFourHours = null)
        {
            return new TemperatureSummary(pastSixHours, pastTwelveHours, pastTwentyFourHours);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PastHoursTemperature"/>. </summary>
        /// <param name="minimum"> minimum. </param>
        /// <param name="maximum"> maximum. </param>
        /// <returns> A new <see cref="Models.PastHoursTemperature"/> instance for mocking. </returns>
        public static PastHoursTemperature PastHoursTemperature(WeatherValue minimum = null, WeatherValue maximum = null)
        {
            return new PastHoursTemperature(minimum, maximum);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DailyForecastResult"/>. </summary>
        /// <param name="summary"> Summary for the main conditions for the requested time period. Notice that summary can cover only part of the time period. </param>
        /// <param name="forecasts"> Forecast data for each requested day. </param>
        /// <returns> A new <see cref="Models.DailyForecastResult"/> instance for mocking. </returns>
        public static DailyForecastResult DailyForecastResult(DailyForecastSummary summary = null, IEnumerable<DailyForecast> forecasts = null)
        {
            forecasts ??= new List<DailyForecast>();

            return new DailyForecastResult(summary, forecasts?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.DailyForecastSummary"/>. </summary>
        /// <param name="startDate"> Date and time that the summary is in effect, displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="endDate"> Date and time that the summary period ends, displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="severity"> severity. </param>
        /// <param name="phrase"> Summary phrase of the daily forecast.  Displayed in specified language. </param>
        /// <param name="category"> one or 2 word(s) to summarize the phrase. </param>
        /// <returns> A new <see cref="Models.DailyForecastSummary"/> instance for mocking. </returns>
        public static DailyForecastSummary DailyForecastSummary(DateTimeOffset? startDate = null, DateTimeOffset? endDate = null, int? severity = null, string phrase = null, string category = null)
        {
            return new DailyForecastSummary(startDate, endDate, severity, phrase, category);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DailyForecast"/>. </summary>
        /// <param name="dateTime"> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="temperature"> Temperature values for the day. </param>
        /// <param name="realFeelTemperature"> RealFeel™ Temperature being returned. </param>
        /// <param name="realFeelTemperatureShade"> RealFeel™ Temperature being returned. Describes what the temperature really feels like in the shade. </param>
        /// <param name="hoursOfSun"> Hours of sun. </param>
        /// <param name="meanTemperatureDeviation"> Summary for mean temperature of Heating Degree Day or Cooling Degree Day information. </param>
        /// <param name="airQuality"> Air quality. </param>
        /// <param name="daytimeForecast"> Day forecast detail. </param>
        /// <param name="nighttimeForecast"> Night forecast detail. </param>
        /// <param name="sources"> Source(s) of the forecast data. </param>
        /// <returns> A new <see cref="Models.DailyForecast"/> instance for mocking. </returns>
        public static DailyForecast DailyForecast(DateTimeOffset? dateTime = null, WeatherValueRange temperature = null, WeatherValueRange realFeelTemperature = null, WeatherValueRange realFeelTemperatureShade = null, float? hoursOfSun = null, DegreeDaySummary meanTemperatureDeviation = null, IEnumerable<AirAndPollen> airQuality = null, DailyForecastDetail daytimeForecast = null, DailyForecastDetail nighttimeForecast = null, IEnumerable<string> sources = null)
        {
            airQuality ??= new List<AirAndPollen>();
            sources ??= new List<string>();

            return new DailyForecast(
                dateTime,
                temperature,
                realFeelTemperature,
                realFeelTemperatureShade,
                hoursOfSun,
                meanTemperatureDeviation,
                airQuality?.ToList(),
                daytimeForecast,
                nighttimeForecast,
                sources?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.DegreeDaySummary"/>. </summary>
        /// <param name="heating"> Number of degrees that the mean temperature is below 65 degrees F/ 18 degree C. </param>
        /// <param name="cooling"> Number of degrees that the mean temperature is above 65 degrees F/ 18 degree C. </param>
        /// <returns> A new <see cref="Models.DegreeDaySummary"/> instance for mocking. </returns>
        public static DegreeDaySummary DegreeDaySummary(WeatherValue heating = null, WeatherValue cooling = null)
        {
            return new DegreeDaySummary(heating, cooling);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AirAndPollen"/>. </summary>
        /// <param name="description"> Name of the pollen or pollutant. For example, grass, mold, weed, air quality, tree and UV index. </param>
        /// <param name="value"> Value of the given type above. Values associated with mold, grass, weed and tree are in units of parts per cubic meter. Both air quality and UV are indices, so they are unitless. </param>
        /// <param name="category"> Category of the air quality or pollution type. For example, low, high, good, moderate, unhealthy, hazardous. </param>
        /// <param name="categoryValue"> Value associated with the air quality or pollution category. These values range from 1 to 6. 1 implying good conditions, 6 implying hazardous conditions. </param>
        /// <param name="airQualityType"> Only exists for air quality. Examples include ozone and particle pollution. </param>
        /// <returns> A new <see cref="Models.AirAndPollen"/> instance for mocking. </returns>
        public static AirAndPollen AirAndPollen(string description = null, int? value = null, string category = null, int? categoryValue = null, string airQualityType = null)
        {
            return new AirAndPollen(description, value, category, categoryValue, airQualityType);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DailyForecastDetail"/>. </summary>
        /// <param name="iconCode"> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </param>
        /// <param name="iconPhrase"> Phrase description of the icon. Displayed in specified language. For example, 'Sunny'. </param>
        /// <param name="localSource"> Local weather data provider information. </param>
        /// <param name="hasPrecipitation"> Indicates the presence or absence of precipitation. True indicates the presence of precipitation, false indicates the absence of precipitation. </param>
        /// <param name="precipitationType"> Specifies the type of precipitation ("Rain" "Snow" "Ice" or "Mix"). If dbz is zero, precipitationType is not present in the response. </param>
        /// <param name="precipitationIntensity"> Description of the intensity. </param>
        /// <param name="shortDescription"> Phrase description of the forecast in specified language. Azure Maps attempts to keep this phrase under 30 characters in length, but some languages/weather events may result in a longer phrase length, exceeding 30 characters. </param>
        /// <param name="longPhrase"> Phrase description of the forecast in specified language. Azure Maps attempts to keep this phrase under 100 characters in length, but some languages/weather events may result in a longer phrase length, exceeding 100 characters. </param>
        /// <param name="precipitationProbability"> Percent representing the probability of precipitation. For example, '20'. </param>
        /// <param name="thunderstormProbability"> Percent representing the probability of a thunderstorm. For example, '80'. </param>
        /// <param name="rainProbability"> Percent representing the probability of rain. For example, '40'. </param>
        /// <param name="snowProbability"> Percent representing the probability of snow. For example, '30'. </param>
        /// <param name="iceProbability"> Percent representing the probability of ice. For example, '30'. </param>
        /// <param name="wind"> Wind details being returned including speed and direction. </param>
        /// <param name="windGust"> Wind gust. Wind gust is a sudden, brief increase in speed of the wind. </param>
        /// <param name="totalLiquid"> Total liquid equivalent of precipitation during the forecast period. </param>
        /// <param name="rain"> Rain. </param>
        /// <param name="snow"> Snow. </param>
        /// <param name="ice"> Ice. </param>
        /// <param name="hoursOfPrecipitation"> Hours of precipitation. </param>
        /// <param name="hoursOfRain"> Hours of rain. </param>
        /// <param name="hoursOfSnow"> Hours of snow. </param>
        /// <param name="hoursOfIce"> Hours of ice. </param>
        /// <param name="cloudCover"> Percent representing cloud cover. </param>
        /// <returns> A new <see cref="Models.DailyForecastDetail"/> instance for mocking. </returns>
        public static DailyForecastDetail DailyForecastDetail(IconCode? iconCode = null, string iconPhrase = null, LocalSource localSource = null, bool? hasPrecipitation = null, PrecipitationType? precipitationType = null, string precipitationIntensity = null, string shortDescription = null, string longPhrase = null, int? precipitationProbability = null, int? thunderstormProbability = null, int? rainProbability = null, int? snowProbability = null, int? iceProbability = null, WindDetails wind = null, WindDetails windGust = null, WeatherValue totalLiquid = null, WeatherValue rain = null, WeatherValue snow = null, WeatherValue ice = null, float? hoursOfPrecipitation = null, float? hoursOfRain = null, float? hoursOfSnow = null, float? hoursOfIce = null, int? cloudCover = null)
        {
            return new DailyForecastDetail(
                iconCode,
                iconPhrase,
                localSource,
                hasPrecipitation,
                precipitationType,
                precipitationIntensity,
                shortDescription,
                longPhrase,
                precipitationProbability,
                thunderstormProbability,
                rainProbability,
                snowProbability,
                iceProbability,
                wind,
                windGust,
                totalLiquid,
                rain,
                snow,
                ice,
                hoursOfPrecipitation,
                hoursOfRain,
                hoursOfSnow,
                hoursOfIce,
                cloudCover);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LocalSource"/>. </summary>
        /// <param name="id"> Numeric identifier, unique to the local data provider. </param>
        /// <param name="name"> Name of the local data provider. Name is displayed in the language specified by language code in URL, if available. Otherwise, Name is displayed in English or the language in which the name was provided. </param>
        /// <param name="weatherCode"> Weather code provided by the local data provider. This weather code allows the forecast to be matched to icons provided by the local data provider instead of Azure Maps icons. </param>
        /// <returns> A new <see cref="Models.LocalSource"/> instance for mocking. </returns>
        public static LocalSource LocalSource(int? id = null, string name = null, string weatherCode = null)
        {
            return new LocalSource(id, name, weatherCode);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WeatherAlongRouteResult"/>. </summary>
        /// <param name="summary"> Short summary of the weather along the route. </param>
        /// <param name="waypoints"> Data for each waypoint returned in the same order as specified in the request. </param>
        /// <returns> A new <see cref="Models.WeatherAlongRouteResult"/> instance for mocking. </returns>
        public static WeatherAlongRouteResult WeatherAlongRouteResult(WeatherAlongRouteSummary summary = null, IEnumerable<WaypointForecast> waypoints = null)
        {
            waypoints ??= new List<WaypointForecast>();

            return new WeatherAlongRouteResult(summary, waypoints?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.WeatherAlongRouteSummary"/>. </summary>
        /// <param name="iconCode"> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </param>
        /// <param name="hazards"> Description of the weather hazard affecting the trip. </param>
        /// <returns> A new <see cref="Models.WeatherAlongRouteSummary"/> instance for mocking. </returns>
        public static WeatherAlongRouteSummary WeatherAlongRouteSummary(IconCode? iconCode = null, WeatherHazards hazards = null)
        {
            return new WeatherAlongRouteSummary(iconCode, hazards);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WeatherHazards"/>. </summary>
        /// <param name="maxHazardIndex">
        /// A severity/hazard index.
        ///   * `0` - No hazard.
        ///   * `1` - Be informed, be aware.
        ///   * `2` - Pay attention, be prepared.
        ///   * `3` - Take action.
        ///   * `4` - Life threatening, emergency.
        /// </param>
        /// <param name="details"> Details of the weather hazards affecting the trip. </param>
        /// <returns> A new <see cref="Models.WeatherHazards"/> instance for mocking. </returns>
        public static WeatherHazards WeatherHazards(HazardIndex? maxHazardIndex = null, IEnumerable<HazardDetail> details = null)
        {
            details ??= new List<HazardDetail>();

            return new WeatherHazards(maxHazardIndex, details?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.HazardDetail"/>. </summary>
        /// <param name="hazardIndex">
        /// A severity/hazard index.
        ///   * `0` - No hazard.
        ///   * `1` - Be informed, be aware.
        ///   * `2` - Pay attention, be prepared.
        ///   * `3` - Take action.
        ///   * `4` - Life threatening, emergency.
        /// </param>
        /// <param name="hazardCode"> A unique identifier (non-displayable) for each type of hazard: LightRain, ModerateRain, HeavyRain, LightMix, ModerateMix, HeavyMix, LightSnow, ModerateSnow, HeavySnow, LightIce, ModerateIce, HeavyIce, Hail, LargeHail, SunGlare, SunGlareHigh, Lightning, SevereLightning, WindModerate, WindHigh, WindExtreme, FloodWarning, FlashFloodWarning, TornadoWarning, TsunamiWarning, SevereThunderstormWarning. </param>
        /// <param name="shortDescription"> A displayable short phrase describing the forecasted conditions and precipitation intensity/type. </param>
        /// <returns> A new <see cref="Models.HazardDetail"/> instance for mocking. </returns>
        public static HazardDetail HazardDetail(HazardIndex? hazardIndex = null, string hazardCode = null, string shortDescription = null)
        {
            return new HazardDetail(hazardIndex, hazardCode, shortDescription);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WaypointForecast"/>. </summary>
        /// <param name="iconCode"> Numeric value representing an image that displays the `iconPhrase`. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#weather-icons) for details. </param>
        /// <param name="shortDescription"> A displayable short phrase describing the forecasted conditions and precipitation intensity/type. </param>
        /// <param name="isDaytime"> Indicates the time of the day. True indicates 'day',', false indicates 'night. </param>
        /// <param name="cloudCover"> Percent representing cloud cover. </param>
        /// <param name="temperature"> Specific value of a given unit related to weather. </param>
        /// <param name="wind"> Wind details being returned including speed and direction. </param>
        /// <param name="windGust"> Wind details being returned including speed and direction. </param>
        /// <param name="precipitation"> Precipitation forecast of the weather along the route. </param>
        /// <param name="lightningCount"> Estimation of thunderstorm intensity on an open scale. A value of 0 means there is no thunderstorm; values of 1 and higher mean there is a thunderstorm in increasing intensity. </param>
        /// <param name="sunGlare"> A rating that indicates how blinding the sun is for the driver. </param>
        /// <param name="hazards"> Description of the weather hazard affecting the trip. </param>
        /// <param name="notifications"> List of weather hazard notifications. </param>
        /// <returns> A new <see cref="Models.WaypointForecast"/> instance for mocking. </returns>
        public static WaypointForecast WaypointForecast(IconCode? iconCode = null, string shortDescription = null, bool? isDaytime = null, int? cloudCover = null, WeatherValue temperature = null, WindDetails wind = null, WindDetails windGust = null, WeatherAlongRoutePrecipitation precipitation = null, int? lightningCount = null, SunGlare sunGlare = null, WeatherHazards hazards = null, IEnumerable<WeatherNotification> notifications = null)
        {
            notifications ??= new List<WeatherNotification>();

            return new WaypointForecast(
                iconCode,
                shortDescription,
                isDaytime,
                cloudCover,
                temperature,
                wind,
                windGust,
                precipitation,
                lightningCount,
                sunGlare,
                hazards,
                notifications?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.WeatherAlongRoutePrecipitation"/>. </summary>
        /// <param name="dbz"> The forecasted precipitation intensity in dBZ (decibels relative to Z) from 0.0 to 100.0. </param>
        /// <param name="type"> Precipitation type. If precipitation should occur, the type that it will be: "RAIN," "HAIL," "SNOW," "ICE," or "MIX.". </param>
        /// <returns> A new <see cref="Models.WeatherAlongRoutePrecipitation"/> instance for mocking. </returns>
        public static WeatherAlongRoutePrecipitation WeatherAlongRoutePrecipitation(double? dbz = null, string type = null)
        {
            return new WeatherAlongRoutePrecipitation(dbz, type);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SunGlare"/>. </summary>
        /// <param name="calculatedVehicleHeading"> If the vehicle heading value is not provided for a waypoint, then the service will calculate a heading based upon the location of neighboring waypoints if provided. </param>
        /// <param name="glareIndex"> An index from 0 to 100 indicating sun glare intensity for a driver. A value of 50 and above can be considered a hazard for some drivers and a value of 100 signifies the driver is driving straight into the sun and atmospheric conditions are clear allowing for the full intensity of the sun to blind the driver. </param>
        /// <returns> A new <see cref="Models.SunGlare"/> instance for mocking. </returns>
        public static SunGlare SunGlare(int? calculatedVehicleHeading = null, int? glareIndex = null)
        {
            return new SunGlare(calculatedVehicleHeading, glareIndex);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WeatherNotification"/>. </summary>
        /// <param name="type"> A type of notification generated to warn drivers of the onset of a hazard, or increase in intensity of a hazard. </param>
        /// <param name="hazardIndex">
        /// A severity/hazard index.
        ///   * `0` - No hazard.
        ///   * `1` - Be informed, be aware.
        ///   * `2` - Pay attention, be prepared.
        ///   * `3` - Take action.
        ///   * `4` - Life threatening, emergency.
        /// </param>
        /// <param name="hazardCode"> A unique identifier (non-displayable) for each type of hazard: LightRain, ModerateRain, HeavyRain, LightMix, ModerateMix, HeavyMix, LightSnow, ModerateSnow, HeavySnow, LightIce, ModerateIce, HeavyIce, Hail, LargeHail, SunGlare, SunGlareHigh, Lightning, SevereLightning, WindModerate, WindHigh, WindExtreme, FloodWarning, FlashFloodWarning, TornadoWarning, TsunamiWarning, SevereThunderstormWarning. </param>
        /// <param name="shortDescription"> A displayable short phrase describing the forecasted conditions and precipitation intensity/type. </param>
        /// <returns> A new <see cref="Models.WeatherNotification"/> instance for mocking. </returns>
        public static WeatherNotification WeatherNotification(string type = null, HazardIndex? hazardIndex = null, string hazardCode = null, string shortDescription = null)
        {
            return new WeatherNotification(type, hazardIndex, hazardCode, shortDescription);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SevereWeatherAlertsResult"/>. </summary>
        /// <param name="results"> A list of all severe weather alerts for the queried location. </param>
        /// <returns> A new <see cref="Models.SevereWeatherAlertsResult"/> instance for mocking. </returns>
        public static SevereWeatherAlertsResult SevereWeatherAlertsResult(IEnumerable<SevereWeatherAlert> results = null)
        {
            results ??= new List<SevereWeatherAlert>();

            return new SevereWeatherAlertsResult(results?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SevereWeatherAlert"/>. </summary>
        /// <param name="countryCode"> 2-character ISO 3166-1 Alpha-2 country code, for example, "US". </param>
        /// <param name="alertId"> A unique numerical identifier for a weather alert. </param>
        /// <param name="description"> Description of the alert. </param>
        /// <param name="category"> Category of the alert. </param>
        /// <param name="priority"> Number signifying the importance or ranking order of the given alert within the country/region it has originated. A lower number signifies a higher priority. For example, 1 is the highest priority. The number varies by country/region and can change over time as each country/region evolves their alert systems. </param>
        /// <param name="classification"> Classification of the alert. This field is not available for all countries and therefore not always returned. </param>
        /// <param name="level"> Severity level of the alert. This field is not available for all countries and therefore not always returned. </param>
        /// <param name="source"> The provider of the alert information. By default the source is returned in English (en-US). The alerts are from official Government Meteorological Agencies and leading global weather alert providers. </param>
        /// <param name="sourceId"> A numerical identifier associated with the source provider name of the alert data. </param>
        /// <param name="disclaimer"> A disclaimer regarding the source of the alert information. This field is not always available. For example, disclaimer may include details about the delays or potential issues related to the alarm. </param>
        /// <param name="alertDetails"> Information about the alert specific to the affected area(s). </param>
        /// <returns> A new <see cref="Models.SevereWeatherAlert"/> instance for mocking. </returns>
        public static SevereWeatherAlert SevereWeatherAlert(string countryCode = null, int? alertId = null, SevereWeatherAlertDescription description = null, string category = null, int? priority = null, string classification = null, string level = null, string source = null, int? sourceId = null, string disclaimer = null, IEnumerable<AlertDetails> alertDetails = null)
        {
            alertDetails ??= new List<AlertDetails>();

            return new SevereWeatherAlert(
                countryCode,
                alertId,
                description,
                category,
                priority,
                classification,
                level,
                source,
                sourceId,
                disclaimer,
                alertDetails?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SevereWeatherAlertDescription"/>. </summary>
        /// <param name="description"> Description of the alert in the specified language. By default English (en-US) is returned if the language parameter is not specified in the request. </param>
        /// <param name="status"> Description of the alert in English (en-US). </param>
        /// <returns> A new <see cref="Models.SevereWeatherAlertDescription"/> instance for mocking. </returns>
        public static SevereWeatherAlertDescription SevereWeatherAlertDescription(string description = null, string status = null)
        {
            return new SevereWeatherAlertDescription(description, status);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AlertDetails"/>. </summary>
        /// <param name="name"> The name of an area which is affected by the alert. The location that was requested falls under the alert area. </param>
        /// <param name="description"> Text summarizing the alert in the returned area. </param>
        /// <param name="startTime"> The start date and time of the alert in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. If the alert crosses multiple time zones the returned time in the response is the local time to the requested coordinate location. </param>
        /// <param name="endTime"> The end date and time of the alert in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. If the alert crosses multiple time zones the returned time in the response is the local time to the requested coordinate location. </param>
        /// <param name="latestStatus"> The latest status of the alert in the current area. </param>
        /// <param name="details"> Full details associated with the alert. Returned if `details`=True. This field is always returned in the language(s) of choice by the issuing provider and Azure Maps only returns what is created by the provider. Please note, some countries/regions may offer their native language and English. Language parameter won’t apply to this field. </param>
        /// <param name="language"> Language of the `alertDetails`. This field  helps to point out that the language of the `alertDetails` may differ from the requested language parameter. Returned if `details`=True. Language code has been derived from the ISO 639-1 Alpha-2 codes. </param>
        /// <returns> A new <see cref="Models.AlertDetails"/> instance for mocking. </returns>
        public static AlertDetails AlertDetails(string name = null, string description = null, DateTimeOffset? startTime = null, DateTimeOffset? endTime = null, LatestStatus latestStatus = null, string details = null, string language = null)
        {
            return new AlertDetails(
                name,
                description,
                startTime,
                endTime,
                latestStatus,
                details,
                language);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LatestStatus"/>. </summary>
        /// <param name="localized"> The latest status keyword for the alert, in the specified language. By default, returned in English (en-US). </param>
        /// <param name="english"> Latest status keyword for the alert, in English (en-US). </param>
        /// <returns> A new <see cref="Models.LatestStatus"/> instance for mocking. </returns>
        public static LatestStatus LatestStatus(string localized = null, LatestStatusKeyword? english = null)
        {
            return new LatestStatus(localized, english);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DailyIndicesResult"/>. </summary>
        /// <param name="results"> A list of all daily indices for the queried location. </param>
        /// <returns> A new <see cref="Models.DailyIndicesResult"/> instance for mocking. </returns>
        public static DailyIndicesResult DailyIndicesResult(IEnumerable<DailyIndex> results = null)
        {
            results ??= new List<DailyIndex>();

            return new DailyIndicesResult(results?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.DailyIndex"/>. </summary>
        /// <param name="indexName"> Name of the index, for example, "Construction", "Outdoor Activity", "Flight Delays". </param>
        /// <param name="indexId"> Numeric ID used to identify the specific index. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#daily-index-range-sets) for details and to see the supported index IDs. For example, the index ID can support UI visualization scenarios. </param>
        /// <param name="dateTime"> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="value"> Index value. Ranges from 0.0 to 10.0. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#daily-index-range-sets) for details and to see the supported ranges. </param>
        /// <param name="categoryDescription"> Textual description for `categoryValue` corresponding to the level that the index value falls under, for example "Very Good". </param>
        /// <param name="categoryValue"> Level that the index value falls under, represented by an integer. This value can be 1 through 5 and should be used in combination with the `ascending` flag because it can differ among indices. For example, the following values apply for Mosquito Activity: Low=1, Moderate=2, High=3, Very High=4, and Extreme=5. </param>
        /// <param name="isAscending"> Describes the direction of the `value` and `categoryValue`. For example, when set to `true`, the poorest index value is 0 and the best index value is 10. When set to `true`, the poorest index value is 10 and the best index value is 0. </param>
        /// <param name="description"> A textual explanation that can be used for display purposes to summarize the index value and category. For example, when the index value for Flight Delays is very good, the description will be "Conditions are excellent for flying!". </param>
        /// <returns> A new <see cref="Models.DailyIndex"/> instance for mocking. </returns>
        public static DailyIndex DailyIndex(string indexName = null, int? indexId = null, DateTimeOffset? dateTime = null, float? value = null, string categoryDescription = null, int? categoryValue = null, bool? isAscending = null, string description = null)
        {
            return new DailyIndex(
                indexName,
                indexId,
                dateTime,
                value,
                categoryDescription,
                categoryValue,
                isAscending,
                description);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ActiveStormResult"/>. </summary>
        /// <param name="activeStorms"> All government-issued active storms. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        /// <returns> A new <see cref="Models.ActiveStormResult"/> instance for mocking. </returns>
        public static ActiveStormResult ActiveStormResult(IEnumerable<ActiveStorm> activeStorms = null, string nextLink = null)
        {
            activeStorms ??= new List<ActiveStorm>();

            return new ActiveStormResult(activeStorms?.ToList(), nextLink);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ActiveStorm"/>. </summary>
        /// <param name="year"> Year of origination. </param>
        /// <param name="basinId"> Basin identifier (AL, EP, SI, NI, CP, NP, SP). </param>
        /// <param name="name"> The name of the depression. </param>
        /// <param name="isActive"> True if the depression has been updated recently. </param>
        /// <param name="isSubtropical"> True when the depression is classified as a subtropical cyclone. </param>
        /// <param name="govId"> Government storm ID. This will match the depression number. </param>
        /// <returns> A new <see cref="Models.ActiveStorm"/> instance for mocking. </returns>
        public static ActiveStorm ActiveStorm(string year = null, BasinId? basinId = null, string name = null, bool? isActive = null, bool? isSubtropical = null, int? govId = null)
        {
            return new ActiveStorm(
                year,
                basinId,
                name,
                isActive,
                isSubtropical,
                govId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StormSearchResult"/>. </summary>
        /// <param name="storms"> Search government-issued storms. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        /// <returns> A new <see cref="Models.StormSearchResult"/> instance for mocking. </returns>
        public static StormSearchResult StormSearchResult(IEnumerable<StormSearchResultItem> storms = null, string nextLink = null)
        {
            storms ??= new List<StormSearchResultItem>();

            return new StormSearchResult(storms?.ToList(), nextLink);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StormSearchResultItem"/>. </summary>
        /// <param name="year"> Year of origination. </param>
        /// <param name="basinId"> Basin identifier (AL, EP, SI, NI, CP, NP, SP). </param>
        /// <param name="name"> The name of the depression. </param>
        /// <param name="isActive"> True if the depression has been updated recently. </param>
        /// <param name="isRetired"> True if the storm name has been permanently retired in the source basin. </param>
        /// <param name="isSubtropical"> True when the depression is classified as a subtropical cyclone. </param>
        /// <param name="govId"> Government storm ID. This will match the depression number. </param>
        /// <returns> A new <see cref="Models.StormSearchResultItem"/> instance for mocking. </returns>
        public static StormSearchResultItem StormSearchResultItem(string year = null, BasinId? basinId = null, string name = null, bool? isActive = null, bool? isRetired = null, bool? isSubtropical = null, int? govId = null)
        {
            return new StormSearchResultItem(
                year,
                basinId,
                name,
                isActive,
                isRetired,
                isSubtropical,
                govId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StormForecastResult"/>. </summary>
        /// <param name="stormForecasts"> The list of Government-issued forecasts. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        /// <returns> A new <see cref="Models.StormForecastResult"/> instance for mocking. </returns>
        public static StormForecastResult StormForecastResult(IEnumerable<StormForecast> stormForecasts = null, string nextLink = null)
        {
            stormForecasts ??= new List<StormForecast>();

            return new StormForecastResult(stormForecasts?.ToList(), nextLink);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StormForecast"/>. </summary>
        /// <param name="timestamp"> Datetime the forecast is valid, displayed in ISO8601 format. </param>
        /// <param name="initializedTimestamp"> Datetime the forecast was created, displayed in ISO8601 format. </param>
        /// <param name="coordinates"> Coordinates of the storm. </param>
        /// <param name="maxWindGust"> Maximum wind gust speed associated with the storm. May be NULL. </param>
        /// <param name="sustainedWind"> Maximum sustained wind speed associated with the storm. May be NULL. </param>
        /// <param name="status"> Possible status values include:&lt;ul&gt;&lt;li&gt;Cyclonic storm&lt;/li&gt;&lt;li&gt;Deep depression&lt;/li&gt;&lt;li&gt;Depression&lt;/li&gt;&lt;li&gt;Extremely severe cyclonic storm&lt;/li&gt;&lt;li&gt;Hurricane category (1-5)&lt;/li&gt;&lt;li&gt;Intense tropical cyclone&lt;/li&gt;&lt;li&gt;Moderate tropical storm&lt;/li&gt;&lt;li&gt;Post-tropical cyclone&lt;/li&gt;&lt;li&gt;Potential tropical cyclone&lt;/li&gt;&lt;li&gt;Severe cyclonic storm&lt;/li&gt;&lt;li&gt;Severe tropical storm&lt;/li&gt;&lt;li&gt;Subtropical&lt;/li&gt;&lt;li&gt;Super cyclonic storm&lt;/li&gt;&lt;li&gt;Tropical cyclone&lt;/li&gt;&lt;li&gt;Tropical cyclone category (1-5)&lt;/li&gt;&lt;li&gt;Tropical depression&lt;/li&gt;&lt;li&gt;Tropical disturbance&lt;/li&gt;&lt;li&gt;Tropical storm&lt;/li&gt;&lt;li&gt;Typhoon&lt;/li&gt;&lt;li&gt;Very intense tropical cyclone&lt;/li&gt;&lt;li&gt;Very severe cyclonic storm&lt;/li&gt;&lt;li&gt;Very strong typhoon&lt;/li&gt;&lt;li&gt;Violent typhoon&lt;/li&gt;&lt;/ul&gt;. </param>
        /// <param name="weatherWindow"> Contains information about the forecast window for the storm during the specified time period (not the entire cone). If windowGeometry=true in the request, this object will include geoJSON details for window geometry. </param>
        /// <param name="windRadiiSummary"> Displayed when details=true or radiiGeometry=true in the request. </param>
        /// <returns> A new <see cref="Models.StormForecast"/> instance for mocking. </returns>
        public static StormForecast StormForecast(string timestamp = null, string initializedTimestamp = null, LatLongPair coordinates = null, WeatherValue maxWindGust = null, WeatherValue sustainedWind = null, string status = null, WeatherWindow weatherWindow = null, IEnumerable<StormWindRadiiSummary> windRadiiSummary = null)
        {
            windRadiiSummary ??= new List<StormWindRadiiSummary>();

            return new StormForecast(
                timestamp,
                initializedTimestamp,
                coordinates,
                maxWindGust,
                sustainedWind,
                status,
                weatherWindow,
                windRadiiSummary?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.LatLongPair"/>. </summary>
        /// <param name="latitude"> Latitude property. </param>
        /// <param name="longitude"> Longitude property. </param>
        /// <returns> A new <see cref="Models.LatLongPair"/> instance for mocking. </returns>
        public static LatLongPair LatLongPair(double? latitude = null, double? longitude = null)
        {
            return new LatLongPair(latitude, longitude);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WeatherWindow"/>. </summary>
        /// <param name="topLeft"> Location of the point on the left side of the window at the time of the timeframe. </param>
        /// <param name="bottomRight"> Location of the point on the right side of the window at the end of the timeframe. </param>
        /// <param name="beginTimestamp"> DateTime of the beginning of the window of movement, displayed in ISO8601 format. </param>
        /// <param name="endTimestamp"> DateTime of the end of the window of movement, displayed in ISO8601 format. </param>
        /// <param name="beginStatus"> Storm status at the beginning of the window. </param>
        /// <param name="endStatus"> Storm status at the end of the window. </param>
        /// <param name="geometry"> Displayed when windowGeometry=true in request. GeoJSON object containing coordinates describing the window of movement during the specified timeframe. </param>
        /// <returns> A new <see cref="Models.WeatherWindow"/> instance for mocking. </returns>
        public static WeatherWindow WeatherWindow(LatLongPair topLeft = null, LatLongPair bottomRight = null, DateTimeOffset? beginTimestamp = null, DateTimeOffset? endTimestamp = null, string beginStatus = null, string endStatus = null, GeoObject geometry = null)
        {
            return new WeatherWindow(
                topLeft,
                bottomRight,
                beginTimestamp,
                endTimestamp,
                beginStatus,
                endStatus,
                geometry);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StormWindRadiiSummary"/>. </summary>
        /// <param name="timestamp"> DateTime for which the wind radii summary data is valid, displayed in ISO8601 format. </param>
        /// <param name="windSpeed"> Wind speed associated with the radiusSectorData. </param>
        /// <param name="radiusSectorData"> Contains the information needed to plot wind radius quadrants. Bearing 0–90 = NE quadrant; 90–180 = SE quadrant; 180–270 = SW quadrant; 270–360 = NW quadrant. </param>
        /// <param name="radiiGeometry"> GeoJSON object. Displayed when radiiGeometry=true in request. Describes the outline of the wind radius quadrants. </param>
        /// <returns> A new <see cref="Models.StormWindRadiiSummary"/> instance for mocking. </returns>
        public static StormWindRadiiSummary StormWindRadiiSummary(string timestamp = null, WeatherValue windSpeed = null, IEnumerable<RadiusSector> radiusSectorData = null, GeoObject radiiGeometry = null)
        {
            radiusSectorData ??= new List<RadiusSector>();

            return new StormWindRadiiSummary(timestamp, windSpeed, radiusSectorData?.ToList(), radiiGeometry);
        }

        /// <summary> Initializes a new instance of <see cref="Models.RadiusSector"/>. </summary>
        /// <param name="beginBearing"> Bearing, in degrees, of the beginning of the quadrant. </param>
        /// <param name="endBearing"> Bearing, in degrees, of the end of the quadrant. </param>
        /// <param name="radius"> The radius of the quadrant, in nautical miles. </param>
        /// <returns> A new <see cref="Models.RadiusSector"/> instance for mocking. </returns>
        public static RadiusSector RadiusSector(double? beginBearing = null, double? endBearing = null, double? radius = null)
        {
            return new RadiusSector(beginBearing, endBearing, radius);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StormLocationsResult"/>. </summary>
        /// <param name="stormLocations"> Locations for an individual government-issued storm. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        /// <returns> A new <see cref="Models.StormLocationsResult"/> instance for mocking. </returns>
        public static StormLocationsResult StormLocationsResult(IEnumerable<StormLocation> stormLocations = null, string nextLink = null)
        {
            stormLocations ??= new List<StormLocation>();

            return new StormLocationsResult(stormLocations?.ToList(), nextLink);
        }

        /// <summary> Initializes a new instance of <see cref="Models.StormLocation"/>. </summary>
        /// <param name="timestamp"> Datetime the forecast is valid, displayed in ISO8601 format. </param>
        /// <param name="coordinates"> Coordinates of the storm. </param>
        /// <param name="maxWindGust"> Maximum wind gust speed associated with the storm. May be NULL. </param>
        /// <param name="sustainedWind"> Maximum sustained wind speed associated with the storm. May be NULL. </param>
        /// <param name="minimumPressure"> Minimum pressure associated with the storm. May be NULL. </param>
        /// <param name="movement"> The storm movement information. </param>
        /// <param name="status"> Storm status, in English. </param>
        /// <param name="isSubtropical"> True when the depression is classified as a subtropical cyclone. </param>
        /// <param name="hasTropicalPotential"> True when storm may develop into a Tropical System. </param>
        /// <param name="isPostTropical"> True when the storm is weakening away, and will no longer become a tropical system. </param>
        /// <param name="windRadiiSummary"> Displayed when details=true or radiiGeometry=true in the request. </param>
        /// <returns> A new <see cref="Models.StormLocation"/> instance for mocking. </returns>
        public static StormLocation StormLocation(string timestamp = null, LatLongPair coordinates = null, WeatherValue maxWindGust = null, WeatherValue sustainedWind = null, WeatherValue minimumPressure = null, WindDetails movement = null, string status = null, bool? isSubtropical = null, bool? hasTropicalPotential = null, bool? isPostTropical = null, IEnumerable<StormWindRadiiSummary> windRadiiSummary = null)
        {
            windRadiiSummary ??= new List<StormWindRadiiSummary>();

            return new StormLocation(
                timestamp,
                coordinates,
                maxWindGust,
                sustainedWind,
                minimumPressure,
                movement,
                status,
                isSubtropical,
                hasTropicalPotential,
                isPostTropical,
                windRadiiSummary?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.AirQualityResult"/>. </summary>
        /// <param name="airQualityResults"> A list of all air quality results for the queried location. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        /// <returns> A new <see cref="Models.AirQualityResult"/> instance for mocking. </returns>
        public static AirQualityResult AirQualityResult(IEnumerable<AirQuality> airQualityResults = null, string nextLink = null)
        {
            airQualityResults ??= new List<AirQuality>();

            return new AirQualityResult(airQualityResults?.ToList(), nextLink);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AirQuality"/>. </summary>
        /// <param name="timestamp"> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="index"> Air quality rating on a scale set by local regulating bodies. Scales can vary widely based on location. See [Wikipedia](https://en.wikipedia.org/wiki/Air_quality_index) for more information. </param>
        /// <param name="globalIndex"> Internationally normalized air quality rating on a scale from 0 to 300 and up, with higher numbers representing worse air quality. </param>
        /// <param name="dominantPollutant"> The pollutant with the highest concentration. </param>
        /// <param name="category"> One-word description of the air quality in the requested language. For example, "Excellent". </param>
        /// <param name="categoryColor"> A unique color corresponding to the category of this air quality result. </param>
        /// <param name="description"> A textual explanation of this air quality result in the requested language. </param>
        /// <param name="pollutants"> Information about individual pollutants. </param>
        /// <returns> A new <see cref="Models.AirQuality"/> instance for mocking. </returns>
        public static AirQuality AirQuality(DateTimeOffset? timestamp = null, float? index = null, float? globalIndex = null, DominantPollutant? dominantPollutant = null, string category = null, string categoryColor = null, string description = null, IEnumerable<Pollutant> pollutants = null)
        {
            pollutants ??= new List<Pollutant>();

            return new AirQuality(
                timestamp,
                index,
                globalIndex,
                dominantPollutant,
                category,
                categoryColor,
                description,
                pollutants?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.Pollutant"/>. </summary>
        /// <param name="type"> Type of pollutant. Please note that more may be added at any time. </param>
        /// <param name="name"> The name of the pollutant in English. </param>
        /// <param name="index"> Air quality rating on a scale set by local regulating bodies. Scales can vary widely based on location. See [Wikipedia](https://en.wikipedia.org/wiki/Air_quality_index) for more information. </param>
        /// <param name="globalIndex"> Internationally normalized air quality rating on a scale from 0 to 300 and up, with higher numbers representing worse air quality. </param>
        /// <param name="concentration"> An object containing the number of pollutant particles per volume of air. </param>
        /// <returns> A new <see cref="Models.Pollutant"/> instance for mocking. </returns>
        public static Pollutant Pollutant(PollutantType? type = null, string name = null, float? index = null, float? globalIndex = null, WeatherValue concentration = null)
        {
            return new Pollutant(type, name, index, globalIndex, concentration);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DailyAirQualityForecastResult"/>. </summary>
        /// <param name="airQualityResults"> A list of all daily air quality forecasts for the queried location. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        /// <returns> A new <see cref="Models.DailyAirQualityForecastResult"/> instance for mocking. </returns>
        public static DailyAirQualityForecastResult DailyAirQualityForecastResult(IEnumerable<DailyAirQuality> airQualityResults = null, string nextLink = null)
        {
            airQualityResults ??= new List<DailyAirQuality>();

            return new DailyAirQualityForecastResult(airQualityResults?.ToList(), nextLink);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DailyAirQuality"/>. </summary>
        /// <param name="timestamp"> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="index"> Air quality rating on a scale set by local regulating bodies. Scales can vary widely based on location. See [Wikipedia](https://en.wikipedia.org/wiki/Air_quality_index) for more information. </param>
        /// <param name="globalIndex"> Internationally normalized air quality rating on a scale from 0 to 300 and up, with higher numbers representing worse air quality. </param>
        /// <param name="dominantPollutant"> The pollutant with the highest concentration. </param>
        /// <param name="category"> One-word description of the air quality in the requested language. For example, "Excellent". </param>
        /// <param name="categoryColor"> A unique color corresponding to the category of this air quality result. </param>
        /// <param name="description"> A textual explanation of this air quality result in the requested language. </param>
        /// <returns> A new <see cref="Models.DailyAirQuality"/> instance for mocking. </returns>
        public static DailyAirQuality DailyAirQuality(DateTimeOffset? timestamp = null, float? index = null, float? globalIndex = null, DominantPollutant? dominantPollutant = null, string category = null, string categoryColor = null, string description = null)
        {
            return new DailyAirQuality(
                timestamp,
                index,
                globalIndex,
                dominantPollutant,
                category,
                categoryColor,
                description);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DailyHistoricalActualsResult"/>. </summary>
        /// <param name="historicalActuals"> Historical actuals for each requested day. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        /// <returns> A new <see cref="Models.DailyHistoricalActualsResult"/> instance for mocking. </returns>
        public static DailyHistoricalActualsResult DailyHistoricalActualsResult(IEnumerable<DailyHistoricalActuals> historicalActuals = null, string nextLink = null)
        {
            historicalActuals ??= new List<DailyHistoricalActuals>();

            return new DailyHistoricalActualsResult(historicalActuals?.ToList(), nextLink);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DailyHistoricalActuals"/>. </summary>
        /// <param name="timestamp"> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="temperature"> Temperature values. </param>
        /// <param name="degreeDaySummary"> Summary of heating or cooling degree day information. Degree days are measures of how cold or warm a location is. A degree day compares the mean (the average of the high and low) outdoor temperatures recorded for a location to a standard temperature of 65 degrees F/ 18 degree C. </param>
        /// <param name="precipitation"> The amount of precipitation (liquid equivalent) that has fallen. </param>
        /// <param name="snowfall"> The amount of snow that has fallen. </param>
        /// <param name="snowDepth"> Snow depth. </param>
        /// <returns> A new <see cref="Models.DailyHistoricalActuals"/> instance for mocking. </returns>
        public static DailyHistoricalActuals DailyHistoricalActuals(DateTimeOffset? timestamp = null, WeatherValueMaxMinAvg temperature = null, DegreeDaySummary degreeDaySummary = null, WeatherValue precipitation = null, WeatherValue snowfall = null, WeatherValue snowDepth = null)
        {
            return new DailyHistoricalActuals(
                timestamp,
                temperature,
                degreeDaySummary,
                precipitation,
                snowfall,
                snowDepth);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WeatherValueMaxMinAvg"/>. </summary>
        /// <param name="maximum"> Maximum temperature for the time period. </param>
        /// <param name="minimum"> Minimum temperature for the time period. </param>
        /// <param name="average"> Average temperature for the time period. </param>
        /// <returns> A new <see cref="Models.WeatherValueMaxMinAvg"/> instance for mocking. </returns>
        public static WeatherValueMaxMinAvg WeatherValueMaxMinAvg(WeatherValue maximum = null, WeatherValue minimum = null, WeatherValue average = null)
        {
            return new WeatherValueMaxMinAvg(maximum, minimum, average);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DailyHistoricalRecordsResult"/>. </summary>
        /// <param name="historicalRecords"> Historical records for each requested day. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        /// <returns> A new <see cref="Models.DailyHistoricalRecordsResult"/> instance for mocking. </returns>
        public static DailyHistoricalRecordsResult DailyHistoricalRecordsResult(IEnumerable<DailyHistoricalRecords> historicalRecords = null, string nextLink = null)
        {
            historicalRecords ??= new List<DailyHistoricalRecords>();

            return new DailyHistoricalRecordsResult(historicalRecords?.ToList(), nextLink);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DailyHistoricalRecords"/>. </summary>
        /// <param name="timestamp"> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="temperature"> Temperature value. </param>
        /// <param name="precipitation"> Maximum amount of precipitation (liquid equivalent) that has fallen. </param>
        /// <param name="snowfall"> Maximum snowfall. </param>
        /// <returns> A new <see cref="Models.DailyHistoricalRecords"/> instance for mocking. </returns>
        public static DailyHistoricalRecords DailyHistoricalRecords(DateTimeOffset? timestamp = null, WeatherValueYearMaxMinAvg temperature = null, WeatherValueYearMax precipitation = null, WeatherValueYearMax snowfall = null)
        {
            return new DailyHistoricalRecords(timestamp, temperature, precipitation, snowfall);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WeatherValueYearMaxMinAvg"/>. </summary>
        /// <param name="maximum"> Maximum temperature for the time period. </param>
        /// <param name="minimum"> Minimum temperature for the time period. </param>
        /// <param name="average"> Average temperature for the time period. </param>
        /// <returns> A new <see cref="Models.WeatherValueYearMaxMinAvg"/> instance for mocking. </returns>
        public static WeatherValueYearMaxMinAvg WeatherValueYearMaxMinAvg(WeatherValueYear maximum = null, WeatherValueYear minimum = null, WeatherValue average = null)
        {
            return new WeatherValueYearMaxMinAvg(maximum, minimum, average);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WeatherValueYear"/>. </summary>
        /// <param name="value"> Rounded value. </param>
        /// <param name="unit"> Type of unit for the returned value. </param>
        /// <param name="unitType"> Numeric ID value associated with the type of unit being displayed. Can be used for unit translation. Please refer to [Weather services in Azure Maps](/azure/azure-maps/weather-services-concepts#daily-index-range-sets) for details. </param>
        /// <param name="year"> Year the value occurred. </param>
        /// <returns> A new <see cref="Models.WeatherValueYear"/> instance for mocking. </returns>
        public static WeatherValueYear WeatherValueYear(float? value = null, string unit = null, int? unitType = null, int? year = null)
        {
            return new WeatherValueYear(value, unit, unitType, year);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WeatherValueYearMax"/>. </summary>
        /// <param name="maximum"> Maximum temperature for the time period. </param>
        /// <returns> A new <see cref="Models.WeatherValueYearMax"/> instance for mocking. </returns>
        public static WeatherValueYearMax WeatherValueYearMax(WeatherValueYear maximum = null)
        {
            return new WeatherValueYearMax(maximum);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DailyHistoricalNormalsResult"/>. </summary>
        /// <param name="historicalNormals"> Historical normals for each requested day. </param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        /// <returns> A new <see cref="Models.DailyHistoricalNormalsResult"/> instance for mocking. </returns>
        public static DailyHistoricalNormalsResult DailyHistoricalNormalsResult(IEnumerable<DailyHistoricalNormals> historicalNormals = null, string nextLink = null)
        {
            historicalNormals ??= new List<DailyHistoricalNormals>();

            return new DailyHistoricalNormalsResult(historicalNormals?.ToList(), nextLink);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DailyHistoricalNormals"/>. </summary>
        /// <param name="timestamp"> Date and time of the current observation displayed in ISO 8601 format, for example, 2019-10-27T19:39:57-08:00. </param>
        /// <param name="temperature"> Temperature values. </param>
        /// <param name="degreeDaySummary"> Summary of heating or cooling degree day information. </param>
        /// <param name="precipitation"> The amount of precipitation (liquid equivalent) that has fallen. </param>
        /// <returns> A new <see cref="Models.DailyHistoricalNormals"/> instance for mocking. </returns>
        public static DailyHistoricalNormals DailyHistoricalNormals(DateTimeOffset? timestamp = null, WeatherValueMaxMinAvg temperature = null, DegreeDaySummary degreeDaySummary = null, WeatherValue precipitation = null)
        {
            return new DailyHistoricalNormals(timestamp, temperature, degreeDaySummary, precipitation);
        }
    }
}
