// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Maps.TimeZone
{
    /// <summary> Client options for MapsRenderClient. </summary>
    public partial class MapsTimeZoneClientOptions : Azure.Core.ClientOptions
    {
        internal const ServiceVersion LatestVersion = ServiceVersion.V1_0;

        /// <summary> The version of the service to use. </summary>
        public enum ServiceVersion
        {
            /// <summary> Service version "1.0". </summary>
            V1_0 = 1,
        }

        internal string Version { get; }

        /// <summary> The Azure Maps endpoint for requests. </summary>
        public Uri Endpoint { get; set; }

        /// <summary> Initializes new instance of MapsTimeZoneClientOptions. </summary>
        /// <param name="version"> Azure Maps TimeZone API version. </param>
        /// <param name="endpoint"> The endpoint for Azure Maps. </param>
        public MapsTimeZoneClientOptions(ServiceVersion version = LatestVersion, Uri endpoint = null)
        {
            Version = version switch
            {
                ServiceVersion.V1_0 => "1.0",
                _ => throw new NotSupportedException()
            };
            Endpoint = endpoint;
        }
    }
}
