// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.Maps.Common;
using Azure.Maps.TimeZone.Models;

namespace Azure.Maps.TimeZone
{
    internal partial class TimezoneRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _clientId;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of TimezoneRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="clientId"> Specifies which account is intended for usage in conjunction with the Microsoft Entra ID security model.  It represents a unique ID for the Azure Maps account and can be retrieved from the Azure Maps management  plane Account API. To use Microsoft Entra ID security in Azure Maps see the following [articles](https://aka.ms/amauthdetails) for guidance. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public TimezoneRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint = null, string clientId = null, string apiVersion = "1.0")
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://atlas.microsoft.com");
            _clientId = clientId;
            _apiVersion = apiVersion ?? throw new ArgumentNullException(nameof(apiVersion));
        }

        internal HttpMessage CreateGetTimezoneByIDRequest(JsonFormat format, string timezoneId, string acceptLanguage, TimeZoneOptions? options, DateTimeOffset? timeStamp, DateTimeOffset? daylightSavingsTimeFrom, int? daylightSavingsTimeLastingYears)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/timezone/byId/", false);
            uri.AppendPath(format.ToString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (options != null)
            {
                uri.AppendQuery("options", options.Value.ToString(), true);
            }
            if (timeStamp != null)
            {
                uri.AppendQuery("timeStamp", timeStamp.Value, "O", true);
            }
            if (daylightSavingsTimeFrom != null)
            {
                uri.AppendQuery("transitionsFrom", daylightSavingsTimeFrom.Value, "O", true);
            }
            if (daylightSavingsTimeLastingYears != null)
            {
                uri.AppendQuery("transitionsYears", daylightSavingsTimeLastingYears.Value, true);
            }
            uri.AppendQuery("query", timezoneId, true);
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            if (acceptLanguage != null)
            {
                request.Headers.Add("Accept-Language", acceptLanguage);
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Use to get the current, historical, and future time zone information for the specified IANA time zone ID. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="timezoneId"> The IANA time zone ID. </param>
        /// <param name="acceptLanguage"> Specifies the language code in which the timezone names should be returned. If no language code is provided, the response will be in "EN". Please refer to [Supported Languages](https://docs.microsoft.com/azure/azure-maps/supported-languages) for details. </param>
        /// <param name="options"> Alternatively, use alias "o". Options available for types of information returned in the result. </param>
        /// <param name="timeStamp"> Alternatively, use alias "stamp", or "s". Reference time, if omitted, the API will use the machine time serving the request. </param>
        /// <param name="daylightSavingsTimeFrom"> Alternatively, use alias "tf". The start date from which daylight savings time (DST) transitions are requested, only applies when "options" = all or "options" = transitions. </param>
        /// <param name="daylightSavingsTimeLastingYears"> Alternatively, use alias "ty". The number of years from "transitionsFrom" for which DST transitions are requested, only applies when "options" = all or "options" = transitions. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="timezoneId"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Get Timezone By ID` API is an HTTP `GET` request that returns current, historical, and future time zone information for the specified IANA time zone ID.
        /// </remarks>
        public async Task<Response<TimeZoneInformation>> GetTimezoneByIDAsync(JsonFormat format, string timezoneId, string acceptLanguage = null, TimeZoneOptions? options = null, DateTimeOffset? timeStamp = null, DateTimeOffset? daylightSavingsTimeFrom = null, int? daylightSavingsTimeLastingYears = null, CancellationToken cancellationToken = default)
        {
            if (timezoneId == null)
            {
                throw new ArgumentNullException(nameof(timezoneId));
            }

            using var message = CreateGetTimezoneByIDRequest(format, timezoneId, acceptLanguage, options, timeStamp, daylightSavingsTimeFrom, daylightSavingsTimeLastingYears);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        TimeZoneInformation value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = TimeZoneInformation.DeserializeTimeZoneInformation(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Use to get the current, historical, and future time zone information for the specified IANA time zone ID. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="timezoneId"> The IANA time zone ID. </param>
        /// <param name="acceptLanguage"> Specifies the language code in which the timezone names should be returned. If no language code is provided, the response will be in "EN". Please refer to [Supported Languages](https://docs.microsoft.com/azure/azure-maps/supported-languages) for details. </param>
        /// <param name="options"> Alternatively, use alias "o". Options available for types of information returned in the result. </param>
        /// <param name="timeStamp"> Alternatively, use alias "stamp", or "s". Reference time, if omitted, the API will use the machine time serving the request. </param>
        /// <param name="daylightSavingsTimeFrom"> Alternatively, use alias "tf". The start date from which daylight savings time (DST) transitions are requested, only applies when "options" = all or "options" = transitions. </param>
        /// <param name="daylightSavingsTimeLastingYears"> Alternatively, use alias "ty". The number of years from "transitionsFrom" for which DST transitions are requested, only applies when "options" = all or "options" = transitions. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="timezoneId"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Get Timezone By ID` API is an HTTP `GET` request that returns current, historical, and future time zone information for the specified IANA time zone ID.
        /// </remarks>
        public Response<TimeZoneInformation> GetTimezoneByID(JsonFormat format, string timezoneId, string acceptLanguage = null, TimeZoneOptions? options = null, DateTimeOffset? timeStamp = null, DateTimeOffset? daylightSavingsTimeFrom = null, int? daylightSavingsTimeLastingYears = null, CancellationToken cancellationToken = default)
        {
            if (timezoneId == null)
            {
                throw new ArgumentNullException(nameof(timezoneId));
            }

            using var message = CreateGetTimezoneByIDRequest(format, timezoneId, acceptLanguage, options, timeStamp, daylightSavingsTimeFrom, daylightSavingsTimeLastingYears);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        TimeZoneInformation value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = TimeZoneInformation.DeserializeTimeZoneInformation(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetTimezoneByCoordinatesRequest(JsonFormat format, IEnumerable<double> coordinates, string acceptLanguage, TimeZoneOptions? options, DateTimeOffset? timeStamp, DateTimeOffset? daylightSavingsTimeFrom, int? daylightSavingsTimeLastingYears)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/timezone/byCoordinates/", false);
            uri.AppendPath(format.ToString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (options != null)
            {
                uri.AppendQuery("options", options.Value.ToString(), true);
            }
            if (timeStamp != null)
            {
                uri.AppendQuery("timeStamp", timeStamp.Value, "O", true);
            }
            if (daylightSavingsTimeFrom != null)
            {
                uri.AppendQuery("transitionsFrom", daylightSavingsTimeFrom.Value, "O", true);
            }
            if (daylightSavingsTimeLastingYears != null)
            {
                uri.AppendQuery("transitionsYears", daylightSavingsTimeLastingYears.Value, true);
            }
            if (coordinates != null && !(coordinates is Common.ChangeTrackingList<double> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("query", coordinates, ",", true);
            }
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            if (acceptLanguage != null)
            {
                request.Headers.Add("Accept-Language", acceptLanguage);
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Use to get the current, historical, and future time zone information for the specified latitude-longitude pair. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="coordinates"> Coordinates of the point for which time zone information is requested. This parameter is a list of coordinates, containing a pair of coordinate(lat, long). When this endpoint is called directly, coordinates are passed in as a single string containing coordinates, separated by commas. </param>
        /// <param name="acceptLanguage"> Specifies the language code in which the timezone names should be returned. If no language code is provided, the response will be in "EN". Please refer to [Supported Languages](https://docs.microsoft.com/azure/azure-maps/supported-languages) for details. </param>
        /// <param name="options"> Alternatively, use alias "o". Options available for types of information returned in the result. </param>
        /// <param name="timeStamp"> Alternatively, use alias "stamp", or "s". Reference time, if omitted, the API will use the machine time serving the request. </param>
        /// <param name="daylightSavingsTimeFrom"> Alternatively, use alias "tf". The start date from which daylight savings time (DST) transitions are requested, only applies when "options" = all or "options" = transitions. </param>
        /// <param name="daylightSavingsTimeLastingYears"> Alternatively, use alias "ty". The number of years from "transitionsFrom" for which DST transitions are requested, only applies when "options" = all or "options" = transitions. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="coordinates"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Get Timezone By Coordinates` API is an HTTP `GET` request that returns current, historical, and future time zone information for a specified latitude-longitude pair. In addition, the API provides sunset and sunrise times for a given location.
        /// </remarks>
        public async Task<Response<TimeZoneInformation>> GetTimezoneByCoordinatesAsync(JsonFormat format, IEnumerable<double> coordinates, string acceptLanguage = null, TimeZoneOptions? options = null, DateTimeOffset? timeStamp = null, DateTimeOffset? daylightSavingsTimeFrom = null, int? daylightSavingsTimeLastingYears = null, CancellationToken cancellationToken = default)
        {
            if (coordinates == null)
            {
                throw new ArgumentNullException(nameof(coordinates));
            }

            using var message = CreateGetTimezoneByCoordinatesRequest(format, coordinates, acceptLanguage, options, timeStamp, daylightSavingsTimeFrom, daylightSavingsTimeLastingYears);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        TimeZoneInformation value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = TimeZoneInformation.DeserializeTimeZoneInformation(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Use to get the current, historical, and future time zone information for the specified latitude-longitude pair. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="coordinates"> Coordinates of the point for which time zone information is requested. This parameter is a list of coordinates, containing a pair of coordinate(lat, long). When this endpoint is called directly, coordinates are passed in as a single string containing coordinates, separated by commas. </param>
        /// <param name="acceptLanguage"> Specifies the language code in which the timezone names should be returned. If no language code is provided, the response will be in "EN". Please refer to [Supported Languages](https://docs.microsoft.com/azure/azure-maps/supported-languages) for details. </param>
        /// <param name="options"> Alternatively, use alias "o". Options available for types of information returned in the result. </param>
        /// <param name="timeStamp"> Alternatively, use alias "stamp", or "s". Reference time, if omitted, the API will use the machine time serving the request. </param>
        /// <param name="daylightSavingsTimeFrom"> Alternatively, use alias "tf". The start date from which daylight savings time (DST) transitions are requested, only applies when "options" = all or "options" = transitions. </param>
        /// <param name="daylightSavingsTimeLastingYears"> Alternatively, use alias "ty". The number of years from "transitionsFrom" for which DST transitions are requested, only applies when "options" = all or "options" = transitions. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="coordinates"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Get Timezone By Coordinates` API is an HTTP `GET` request that returns current, historical, and future time zone information for a specified latitude-longitude pair. In addition, the API provides sunset and sunrise times for a given location.
        /// </remarks>
        public Response<TimeZoneInformation> GetTimezoneByCoordinates(JsonFormat format, IEnumerable<double> coordinates, string acceptLanguage = null, TimeZoneOptions? options = null, DateTimeOffset? timeStamp = null, DateTimeOffset? daylightSavingsTimeFrom = null, int? daylightSavingsTimeLastingYears = null, CancellationToken cancellationToken = default)
        {
            if (coordinates == null)
            {
                throw new ArgumentNullException(nameof(coordinates));
            }

            using var message = CreateGetTimezoneByCoordinatesRequest(format, coordinates, acceptLanguage, options, timeStamp, daylightSavingsTimeFrom, daylightSavingsTimeLastingYears);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        TimeZoneInformation value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = TimeZoneInformation.DeserializeTimeZoneInformation(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetWindowsTimezoneIdsRequest(JsonFormat format)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/timezone/enumWindows/", false);
            uri.AppendPath(format.ToString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Use to get the list of Windows Time Zone IDs. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks>
        ///
        /// The `Get Windows Time Zones` API is an HTTP `GET` request that returns a full list of Windows Time Zone IDs.
        /// </remarks>
        public async Task<Response<IReadOnlyList<TimeZoneWindows>>> GetWindowsTimezoneIdsAsync(JsonFormat format, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetWindowsTimezoneIdsRequest(format);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IReadOnlyList<TimeZoneWindows> value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        List<TimeZoneWindows> array = new List<TimeZoneWindows>();
                        foreach (var item in document.RootElement.EnumerateArray())
                        {
                            array.Add(TimeZoneWindows.DeserializeTimeZoneWindows(item));
                        }
                        value = array;
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Use to get the list of Windows Time Zone IDs. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks>
        ///
        /// The `Get Windows Time Zones` API is an HTTP `GET` request that returns a full list of Windows Time Zone IDs.
        /// </remarks>
        public Response<IReadOnlyList<TimeZoneWindows>> GetWindowsTimezoneIds(JsonFormat format, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetWindowsTimezoneIdsRequest(format);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IReadOnlyList<TimeZoneWindows> value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        List<TimeZoneWindows> array = new List<TimeZoneWindows>();
                        foreach (var item in document.RootElement.EnumerateArray())
                        {
                            array.Add(TimeZoneWindows.DeserializeTimeZoneWindows(item));
                        }
                        value = array;
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetIanaTimezoneIdsRequest(JsonFormat format)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/timezone/enumIana/", false);
            uri.AppendPath(format.ToString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Use to get the list of IANA time zone IDs. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks>
        ///
        /// The `Get IANA Time Zones` API is an HTTP `GET` request that returns a full list of Internet Assigned Numbers Authority (IANA) time zone IDs. Updates to the IANA service are reflected in the system within one day.
        /// </remarks>
        public async Task<Response<IReadOnlyList<IanaId>>> GetIanaTimezoneIdsAsync(JsonFormat format, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetIanaTimezoneIdsRequest(format);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IReadOnlyList<IanaId> value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        List<IanaId> array = new List<IanaId>();
                        foreach (var item in document.RootElement.EnumerateArray())
                        {
                            array.Add(IanaId.DeserializeIanaId(item));
                        }
                        value = array;
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Use to get the list of IANA time zone IDs. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks>
        ///
        /// The `Get IANA Time Zones` API is an HTTP `GET` request that returns a full list of Internet Assigned Numbers Authority (IANA) time zone IDs. Updates to the IANA service are reflected in the system within one day.
        /// </remarks>
        public Response<IReadOnlyList<IanaId>> GetIanaTimezoneIds(JsonFormat format, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetIanaTimezoneIdsRequest(format);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IReadOnlyList<IanaId> value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        List<IanaId> array = new List<IanaId>();
                        foreach (var item in document.RootElement.EnumerateArray())
                        {
                            array.Add(IanaId.DeserializeIanaId(item));
                        }
                        value = array;
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetIanaVersionRequest(JsonFormat format)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/timezone/ianaVersion/", false);
            uri.AppendPath(format.ToString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Use to get the current IANA version number. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks>
        ///
        /// The `Get Time Zone IANA Version` API is an HTTP `GET` request that returns the current Internet Assigned Numbers Authority (IANA) version number as Metadata.
        /// </remarks>
        public async Task<Response<TimeZoneIanaVersionResult>> GetIanaVersionAsync(JsonFormat format, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetIanaVersionRequest(format);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        TimeZoneIanaVersionResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = TimeZoneIanaVersionResult.DeserializeTimeZoneIanaVersionResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Use to get the current IANA version number. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <remarks>
        ///
        /// The `Get Time Zone IANA Version` API is an HTTP `GET` request that returns the current Internet Assigned Numbers Authority (IANA) version number as Metadata.
        /// </remarks>
        public Response<TimeZoneIanaVersionResult> GetIanaVersion(JsonFormat format, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetIanaVersionRequest(format);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        TimeZoneIanaVersionResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = TimeZoneIanaVersionResult.DeserializeTimeZoneIanaVersionResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateConvertWindowsTimezoneToIanaRequest(JsonFormat format, string windowsTimezoneId, string windowsTerritoryCode)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/timezone/windowsToIana/", false);
            uri.AppendPath(format.ToString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            uri.AppendQuery("query", windowsTimezoneId, true);
            if (windowsTerritoryCode != null)
            {
                uri.AppendQuery("territory", windowsTerritoryCode, true);
            }
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        /// <summary> Use to get the IANA ID. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="windowsTimezoneId"> The Windows time zone ID. </param>
        /// <param name="windowsTerritoryCode"> Windows Time Zone territory code. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="windowsTimezoneId"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Get Windows to IANA Time Zone` API is an HTTP `GET` request that returns a corresponding Internet Assigned Numbers Authority (IANA) ID, given a valid Windows Time Zone ID. Multiple IANA IDs may be returned for a single Windows ID. It is possible to narrow these results by adding an optional territory parameter.
        /// </remarks>
        public async Task<Response<IReadOnlyList<IanaId>>> ConvertWindowsTimezoneToIanaAsync(JsonFormat format, string windowsTimezoneId, string windowsTerritoryCode = null, CancellationToken cancellationToken = default)
        {
            if (windowsTimezoneId == null)
            {
                throw new ArgumentNullException(nameof(windowsTimezoneId));
            }

            using var message = CreateConvertWindowsTimezoneToIanaRequest(format, windowsTimezoneId, windowsTerritoryCode);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IReadOnlyList<IanaId> value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        List<IanaId> array = new List<IanaId>();
                        foreach (var item in document.RootElement.EnumerateArray())
                        {
                            array.Add(IanaId.DeserializeIanaId(item));
                        }
                        value = array;
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Use to get the IANA ID. </summary>
        /// <param name="format"> Desired format of the response. Only `json` format is supported. The default value is AutoRest.CSharp.Output.Models.Types.EnumTypeValue. </param>
        /// <param name="windowsTimezoneId"> The Windows time zone ID. </param>
        /// <param name="windowsTerritoryCode"> Windows Time Zone territory code. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="windowsTimezoneId"/> is null. </exception>
        /// <remarks>
        ///
        /// The `Get Windows to IANA Time Zone` API is an HTTP `GET` request that returns a corresponding Internet Assigned Numbers Authority (IANA) ID, given a valid Windows Time Zone ID. Multiple IANA IDs may be returned for a single Windows ID. It is possible to narrow these results by adding an optional territory parameter.
        /// </remarks>
        public Response<IReadOnlyList<IanaId>> ConvertWindowsTimezoneToIana(JsonFormat format, string windowsTimezoneId, string windowsTerritoryCode = null, CancellationToken cancellationToken = default)
        {
            if (windowsTimezoneId == null)
            {
                throw new ArgumentNullException(nameof(windowsTimezoneId));
            }

            using var message = CreateConvertWindowsTimezoneToIanaRequest(format, windowsTimezoneId, windowsTerritoryCode);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        IReadOnlyList<IanaId> value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        List<IanaId> array = new List<IanaId>();
                        foreach (var item in document.RootElement.EnumerateArray())
                        {
                            array.Add(IanaId.DeserializeIanaId(item));
                        }
                        value = array;
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
