// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.TimeZone.Models
{
    /// <summary> The TimezoneWindows. </summary>
    public partial class TimeZoneWindows
    {
        /// <summary> Initializes a new instance of <see cref="TimeZoneWindows"/>. </summary>
        internal TimeZoneWindows()
        {
            IanaIds = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="TimeZoneWindows"/>. </summary>
        /// <param name="windowsId"> Windows Id property. </param>
        /// <param name="territory"> Territory property. </param>
        /// <param name="ianaIds"> IanaIds array. </param>
        internal TimeZoneWindows(string windowsId, string territory, IReadOnlyList<string> ianaIds)
        {
            WindowsId = windowsId;
            Territory = territory;
            IanaIds = ianaIds;
        }

        /// <summary> Windows Id property. </summary>
        public string WindowsId { get; }
        /// <summary> Territory property. </summary>
        public string Territory { get; }
        /// <summary> IanaIds array. </summary>
        public IReadOnlyList<string> IanaIds { get; }
    }
}
