// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.TimeZone.Models
{
    public partial class TimeZoneInformation
    {
        internal static TimeZoneInformation DeserializeTimeZoneInformation(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string version = default;
            DateTimeOffset? referenceUtcTimestamp = default;
            IReadOnlyList<TimezoneId> timeZones = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("Version"u8))
                {
                    version = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("ReferenceUtcTimestamp"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    referenceUtcTimestamp = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("TimeZones"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<TimezoneId> array = new List<TimezoneId>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(TimezoneId.DeserializeTimezoneId(item));
                    }
                    timeZones = array;
                    continue;
                }
            }
            return new TimeZoneInformation(version, referenceUtcTimestamp, timeZones ?? new ChangeTrackingList<TimezoneId>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static TimeZoneInformation FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeTimeZoneInformation(document.RootElement);
        }
    }
}
