// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.TimeZone.Models
{
    public partial class TimeZoneIanaVersionResult
    {
        internal static TimeZoneIanaVersionResult DeserializeTimeZoneIanaVersionResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string version = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("Version"u8))
                {
                    version = property.Value.GetString();
                    continue;
                }
            }
            return new TimeZoneIanaVersionResult(version);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static TimeZoneIanaVersionResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeTimeZoneIanaVersionResult(document.RootElement);
        }
    }
}
