// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.TimeZone
{
    public partial class ReferenceTime
    {
        internal static ReferenceTime DeserializeReferenceTime(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string tag = default;
            string standardOffset = default;
            string daylightSavings = default;
            string wallTime = default;
            int? posixTzValidYear = default;
            string posixTz = default;
            DateTimeOffset? sunrise = default;
            DateTimeOffset? sunset = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("Tag"u8))
                {
                    tag = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("StandardOffset"u8))
                {
                    standardOffset = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("DaylightSavings"u8))
                {
                    daylightSavings = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("WallTime"u8))
                {
                    wallTime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("PosixTzValidYear"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    posixTzValidYear = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("PosixTz"u8))
                {
                    posixTz = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("Sunrise"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sunrise = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("Sunset"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sunset = property.Value.GetDateTimeOffset("O");
                    continue;
                }
            }
            return new ReferenceTime(
                tag,
                standardOffset,
                daylightSavings,
                wallTime,
                posixTzValidYear,
                posixTz,
                sunrise,
                sunset);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static ReferenceTime FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeReferenceTime(document.RootElement);
        }
    }
}
