// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.TimeZone
{
    public partial class IanaId
    {
        internal static IanaId DeserializeIanaId(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string id = default;
            bool? isAlias = default;
            string aliasOf = default;
            bool? hasZone1970Location = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("Id"u8))
                {
                    id = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("IsAlias"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isAlias = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("AliasOf"u8))
                {
                    aliasOf = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("HasZone1970Location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hasZone1970Location = property.Value.GetBoolean();
                    continue;
                }
            }
            return new IanaId(id, isAlias, aliasOf, hasZone1970Location);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static IanaId FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeIanaId(document.RootElement);
        }
    }
}
