// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Maps.TimeZone.Models;

namespace Azure.Maps.TimeZone
{
    /// <summary> Model factory for models. </summary>
    public static partial class MapsTimeZoneModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.TimeZoneInformation"/>. </summary>
        /// <param name="version"> Version property. </param>
        /// <param name="referenceUtcTimestamp"> Reference Utc Timestamp property. </param>
        /// <param name="timeZones"> TimeZoneId array. </param>
        /// <returns> A new <see cref="Models.TimeZoneInformation"/> instance for mocking. </returns>
        public static TimeZoneInformation TimeZoneInformation(string version = null, DateTimeOffset? referenceUtcTimestamp = null, IEnumerable<TimezoneId> timeZones = null)
        {
            timeZones ??= new List<TimezoneId>();

            return new TimeZoneInformation(version, referenceUtcTimestamp, timeZones?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="TimeZone.TimezoneId"/>. </summary>
        /// <param name="id"> Id property. </param>
        /// <param name="aliases">
        /// An array of time zone ID aliases. Only returned when [options]=*zoneinfo* or *all*.
        ///
        /// Note: may be null.
        /// </param>
        /// <param name="countries"> An array of country/region records. Only returned when [options]=*zoneinfo* or *all*. </param>
        /// <param name="names"> Timezone names object. </param>
        /// <param name="referenceTime"> Details in effect at the local time. </param>
        /// <param name="representativePoint"> Representative point property. </param>
        /// <param name="timeTransitions"> Time zone DST transitions from [transitionsFrom] until timestamp + 1 year. </param>
        /// <returns> A new <see cref="TimeZone.TimezoneId"/> instance for mocking. </returns>
        public static TimezoneId TimezoneId(string id = null, IEnumerable<string> aliases = null, IEnumerable<CountryRecord> countries = null, TimeZoneNames names = null, ReferenceTime referenceTime = null, RepresentativePoint representativePoint = null, IEnumerable<TimeTransition> timeTransitions = null)
        {
            aliases ??= new List<string>();
            countries ??= new List<CountryRecord>();
            timeTransitions ??= new List<TimeTransition>();

            return new TimezoneId(
                id,
                aliases?.ToList(),
                countries?.ToList(),
                names,
                referenceTime,
                representativePoint,
                timeTransitions?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="TimeZone.CountryRecord"/>. </summary>
        /// <param name="name"> country/region Name. </param>
        /// <param name="code"> ISO-3166 2-letter country/region code for the country/region. </param>
        /// <returns> A new <see cref="TimeZone.CountryRecord"/> instance for mocking. </returns>
        public static CountryRecord CountryRecord(string name = null, string code = null)
        {
            return new CountryRecord(name, code);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TimeZoneNames"/>. </summary>
        /// <param name="iso6391LanguageCode"> The ISO 639-1 language code of the Names. </param>
        /// <param name="generic"> Generic Name. </param>
        /// <param name="standard"> Standard Name. </param>
        /// <param name="daylight"> Daylight Name. </param>
        /// <returns> A new <see cref="Models.TimeZoneNames"/> instance for mocking. </returns>
        public static TimeZoneNames TimeZoneNames(string iso6391LanguageCode = null, string generic = null, string standard = null, string daylight = null)
        {
            return new TimeZoneNames(iso6391LanguageCode, generic, standard, daylight);
        }

        /// <summary> Initializes a new instance of <see cref="TimeZone.ReferenceTime"/>. </summary>
        /// <param name="tag"> Time zone name in effect at the reference timestamp (i.e. PST or PDT depending whether Daylight Savings Time is in effect). </param>
        /// <param name="standardOffset"> UTC offset in effect at the `ReferenceUTCTimestamp`. </param>
        /// <param name="daylightSavings"> Time saving in minutes in effect at the `ReferenceUTCTimestamp`. </param>
        /// <param name="wallTime"> Current wall time at the given time zone as shown in the `Tag` property. </param>
        /// <param name="posixTzValidYear"> The year this POSIX string is valid for. Note: A POSIX string will only be valid in the given year. </param>
        /// <param name="posixTz"> POSIX string used to set the time zone environment variable. </param>
        /// <param name="sunrise"> Sunrise at the given time zone as shown in the `Tag` property. The sunrise is described in the ISO8601 format. (Only be populated if the call is byCoordinates). </param>
        /// <param name="sunset"> Sunset at the given time zone as shown in the `Tag` property. The sunset is described in the ISO8601 format.(Only be populated if the call is byCoordinates). </param>
        /// <returns> A new <see cref="TimeZone.ReferenceTime"/> instance for mocking. </returns>
        public static ReferenceTime ReferenceTime(string tag = null, string standardOffset = null, string daylightSavings = null, string wallTime = null, int? posixTzValidYear = null, string posixTz = null, DateTimeOffset? sunrise = null, DateTimeOffset? sunset = null)
        {
            return new ReferenceTime(
                tag,
                standardOffset,
                daylightSavings,
                wallTime,
                posixTzValidYear,
                posixTz,
                sunrise,
                sunset);
        }

        /// <summary> Initializes a new instance of <see cref="TimeZone.TimeTransition"/>. </summary>
        /// <param name="tag"> Tag property. </param>
        /// <param name="standardOffset"> StandardOffset property. </param>
        /// <param name="daylightSavings"> DaylightSavings property. </param>
        /// <param name="utcStart"> Start date, start time for this transition period. </param>
        /// <param name="utcEnd"> End date, end time for this transition period. </param>
        /// <returns> A new <see cref="TimeZone.TimeTransition"/> instance for mocking. </returns>
        public static TimeTransition TimeTransition(string tag = null, string standardOffset = null, string daylightSavings = null, DateTimeOffset? utcStart = null, DateTimeOffset? utcEnd = null)
        {
            return new TimeTransition(tag, standardOffset, daylightSavings, utcStart, utcEnd);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TimeZoneWindows"/>. </summary>
        /// <param name="windowsId"> Windows Id property. </param>
        /// <param name="territory"> Territory property. </param>
        /// <param name="ianaIds"> IanaIds array. </param>
        /// <returns> A new <see cref="Models.TimeZoneWindows"/> instance for mocking. </returns>
        public static TimeZoneWindows TimeZoneWindows(string windowsId = null, string territory = null, IEnumerable<string> ianaIds = null)
        {
            ianaIds ??= new List<string>();

            return new TimeZoneWindows(windowsId, territory, ianaIds?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="TimeZone.IanaId"/>. </summary>
        /// <param name="id"> Id property. </param>
        /// <param name="isAlias"> IsAlias property. </param>
        /// <param name="aliasOf"> AliasOf property. </param>
        /// <param name="hasZone1970Location"> This attribute returns `True` if the IanaId has any country/zone associated with it. </param>
        /// <returns> A new <see cref="TimeZone.IanaId"/> instance for mocking. </returns>
        public static IanaId IanaId(string id = null, bool? isAlias = null, string aliasOf = null, bool? hasZone1970Location = null)
        {
            return new IanaId(id, isAlias, aliasOf, hasZone1970Location);
        }

        /// <summary> Initializes a new instance of <see cref="Models.TimeZoneIanaVersionResult"/>. </summary>
        /// <param name="version"> Version property. </param>
        /// <returns> A new <see cref="Models.TimeZoneIanaVersionResult"/> instance for mocking. </returns>
        public static TimeZoneIanaVersionResult TimeZoneIanaVersionResult(string version = null)
        {
            return new TimeZoneIanaVersionResult(version);
        }
    }
}
