// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Maps.Search
{
    /// <summary> Client options for SearchClient. </summary>
    public partial class MapsSearchClientOptions : ClientOptions
    {
        internal const ServiceVersion LatestVersion = ServiceVersion.V2_0;

        /// <summary> The version of the service to use. </summary>
        public enum ServiceVersion
        {
            /// <summary> Service version "1.0". </summary>
            V1_0 = 1,
            /// <summary> Service version "2.0". </summary>
            V2_0 = 2,
        }

        internal string Version { get; }

        /// <summary> The Azure Maps endpoint for requests. </summary>
        public Uri Endpoint { get; set; }

        /// <summary> The langauge of search result returned by the requests. </summary>
        public SearchLanguage SearchLanguage { get; set; }

        /// <summary> Initializes new instance of SearchClientOptions. </summary>
        public MapsSearchClientOptions(ServiceVersion version = LatestVersion, Uri endpoint = null, SearchLanguage language = null) 
        {
            Version = version switch
            {
                ServiceVersion.V1_0 => "1.0",
                ServiceVersion.V2_0 => "2023-06-01",
                _ => throw new NotSupportedException()
            };

            Endpoint = endpoint;
            SearchLanguage = language;
        }
    }
}
