// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.Maps.Common;
using Azure.Maps.Search.Models;

namespace Azure.Maps.Search
{
    internal partial class SearchRestClient
    {
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;
        private readonly string _acceptLanguage;
        private readonly string _clientId;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> Initializes a new instance of SearchRestClient. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <param name="acceptLanguage">
        /// Language in which search results should be returned.
        ///
        /// Please refer to [Supported Languages](/azure/azure-maps/supported-languages) for details.
        /// </param>
        /// <param name="clientId"> Specifies which account is intended for usage in conjunction with the Azure AD security model.  It represents a unique ID for the Azure Maps account and can be retrieved from the Azure Maps management  plane Account API. To use Azure AD security in Azure Maps see the following [articles](https://aka.ms/amauthdetails) for guidance. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="clientDiagnostics"/>, <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public SearchRestClient(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, Uri endpoint = null, string apiVersion = "2023-06-01", string acceptLanguage = null, string clientId = null)
        {
            ClientDiagnostics = clientDiagnostics ?? throw new ArgumentNullException(nameof(clientDiagnostics));
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://atlas.microsoft.com");
            _apiVersion = apiVersion ?? throw new ArgumentNullException(nameof(apiVersion));
            _acceptLanguage = acceptLanguage;
            _clientId = clientId;
        }

        internal HttpMessage CreateGetGeocodingRequest(int? top, string query, string addressLine, string countryRegion, IEnumerable<double> boundingBox, string view, IEnumerable<double> coordinates, string adminDistrict, string adminDistrict2, string adminDistrict3, string locality, string postalCode)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/geocode", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (top != null)
            {
                uri.AppendQuery("top", top.Value, true);
            }
            if (query != null)
            {
                uri.AppendQuery("query", query, true);
            }
            if (addressLine != null)
            {
                uri.AppendQuery("addressLine", addressLine, true);
            }
            if (countryRegion != null)
            {
                uri.AppendQuery("countryRegion", countryRegion, true);
            }
            if (boundingBox != null && !(boundingBox is Common.ChangeTrackingList<double> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("boundingBox", boundingBox, ",", true);
            }
            if (view != null)
            {
                uri.AppendQuery("view", view, true);
            }
            if (coordinates != null && !(coordinates is Common.ChangeTrackingList<double> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                uri.AppendQueryDelimited("coordinates", coordinates, ",", true);
            }
            if (adminDistrict != null)
            {
                uri.AppendQuery("adminDistrict", adminDistrict, true);
            }
            if (adminDistrict2 != null)
            {
                uri.AppendQuery("adminDistrict2", adminDistrict2, true);
            }
            if (adminDistrict3 != null)
            {
                uri.AppendQuery("adminDistrict3", adminDistrict3, true);
            }
            if (locality != null)
            {
                uri.AppendQuery("locality", locality, true);
            }
            if (postalCode != null)
            {
                uri.AppendQuery("postalCode", postalCode, true);
            }
            request.Uri = uri;
            if (_acceptLanguage != null)
            {
                request.Headers.Add("Accept-Language", _acceptLanguage);
            }
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            request.Headers.Add("Accept", "application/geo+json, application/json");
            return message;
        }

        /// <summary>
        /// **Geocoding**
        ///
        /// **Applies to:** see [pricing tiers](https://aka.ms/AzureMapsPricingTier).
        ///
        /// In many cases, the complete search service might be too much, for instance if you are only interested in traditional geocoding. Search can also be accessed for address look up exclusively. The geocoding is performed by hitting the geocoding endpoint with just the address or partial address in question. The geocoding search index will be queried for everything above the street level data. No Point of Interest (POIs) will be returned. Note that the geocoder is very tolerant of typos and incomplete addresses. It will also handle everything from exact street addresses or street or intersections as well as higher level geographies such as city centers, counties, states etc.
        /// </summary>
        /// <param name="top"> Maximum number of responses that will be returned. Default: 5, minimum: 1 and maximum: 20. </param>
        /// <param name="query"> A string that contains information about a location, such as an address or landmark name. </param>
        /// <param name="addressLine">
        /// The official street line of an address relative to the area, as specified by the locality, or postalCode, properties. Typical use of this element would be to provide a street address or any official address.
        ///
        /// **If query is given, should not use this parameter.**
        /// </param>
        /// <param name="countryRegion">
        /// Signal for the geocoding result to an [ISO 3166-1 Alpha-2 region/country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) that is specified e.g. FR./
        ///
        /// **If query is given, should not use this parameter.**
        /// </param>
        /// <param name="boundingBox">
        /// A rectangular area on the earth defined as a bounding box object. The sides of the rectangles are defined by longitude and latitude values. When you specify this parameter, the geographical area is taken into account when computing the results of a location query.
        ///
        /// Example: lon1,lat1,lon2,lat2
        /// </param>
        /// <param name="view">
        /// A string that represents an [ISO 3166-1 Alpha-2 region/country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). This will alter Geopolitical disputed borders and labels to align with the specified user region. By default, the View parameter is set to “Auto” even if you haven’t defined it in the request.
        ///
        /// Please refer to [Supported Views](https://aka.ms/AzureMapsLocalizationViews) for details and to see the available Views.
        /// </param>
        /// <param name="coordinates"> A point on the earth specified as a longitude and latitude. When you specify this parameter, the user’s location is taken into account and the results returned may be more relevant to the user. Example: &amp;coordinates=lon,lat. </param>
        /// <param name="adminDistrict">
        /// The country subdivision portion of an address, such as WA.
        ///
        /// **If query is given, should not use this parameter.**
        /// </param>
        /// <param name="adminDistrict2">
        /// The county for the structured address, such as King.
        ///
        /// **If query is given, should not use this parameter.**
        /// </param>
        /// <param name="adminDistrict3">
        /// The named area for the structured address.
        ///
        /// **If query is given, should not use this parameter.**
        /// </param>
        /// <param name="locality">
        /// The locality portion of an address, such as Seattle.
        ///
        /// **If query is given, should not use this parameter.**
        /// </param>
        /// <param name="postalCode">
        /// The postal code portion of an address.
        ///
        /// **If query is given, should not use this parameter.**
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<GeocodingResponse>> GetGeocodingAsync(int? top = null, string query = null, string addressLine = null, string countryRegion = null, IEnumerable<double> boundingBox = null, string view = null, IEnumerable<double> coordinates = null, string adminDistrict = null, string adminDistrict2 = null, string adminDistrict3 = null, string locality = null, string postalCode = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetGeocodingRequest(top, query, addressLine, countryRegion, boundingBox, view, coordinates, adminDistrict, adminDistrict2, adminDistrict3, locality, postalCode);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GeocodingResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = GeocodingResponse.DeserializeGeocodingResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// **Geocoding**
        ///
        /// **Applies to:** see [pricing tiers](https://aka.ms/AzureMapsPricingTier).
        ///
        /// In many cases, the complete search service might be too much, for instance if you are only interested in traditional geocoding. Search can also be accessed for address look up exclusively. The geocoding is performed by hitting the geocoding endpoint with just the address or partial address in question. The geocoding search index will be queried for everything above the street level data. No Point of Interest (POIs) will be returned. Note that the geocoder is very tolerant of typos and incomplete addresses. It will also handle everything from exact street addresses or street or intersections as well as higher level geographies such as city centers, counties, states etc.
        /// </summary>
        /// <param name="top"> Maximum number of responses that will be returned. Default: 5, minimum: 1 and maximum: 20. </param>
        /// <param name="query"> A string that contains information about a location, such as an address or landmark name. </param>
        /// <param name="addressLine">
        /// The official street line of an address relative to the area, as specified by the locality, or postalCode, properties. Typical use of this element would be to provide a street address or any official address.
        ///
        /// **If query is given, should not use this parameter.**
        /// </param>
        /// <param name="countryRegion">
        /// Signal for the geocoding result to an [ISO 3166-1 Alpha-2 region/country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) that is specified e.g. FR./
        ///
        /// **If query is given, should not use this parameter.**
        /// </param>
        /// <param name="boundingBox">
        /// A rectangular area on the earth defined as a bounding box object. The sides of the rectangles are defined by longitude and latitude values. When you specify this parameter, the geographical area is taken into account when computing the results of a location query.
        ///
        /// Example: lon1,lat1,lon2,lat2
        /// </param>
        /// <param name="view">
        /// A string that represents an [ISO 3166-1 Alpha-2 region/country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). This will alter Geopolitical disputed borders and labels to align with the specified user region. By default, the View parameter is set to “Auto” even if you haven’t defined it in the request.
        ///
        /// Please refer to [Supported Views](https://aka.ms/AzureMapsLocalizationViews) for details and to see the available Views.
        /// </param>
        /// <param name="coordinates"> A point on the earth specified as a longitude and latitude. When you specify this parameter, the user’s location is taken into account and the results returned may be more relevant to the user. Example: &amp;coordinates=lon,lat. </param>
        /// <param name="adminDistrict">
        /// The country subdivision portion of an address, such as WA.
        ///
        /// **If query is given, should not use this parameter.**
        /// </param>
        /// <param name="adminDistrict2">
        /// The county for the structured address, such as King.
        ///
        /// **If query is given, should not use this parameter.**
        /// </param>
        /// <param name="adminDistrict3">
        /// The named area for the structured address.
        ///
        /// **If query is given, should not use this parameter.**
        /// </param>
        /// <param name="locality">
        /// The locality portion of an address, such as Seattle.
        ///
        /// **If query is given, should not use this parameter.**
        /// </param>
        /// <param name="postalCode">
        /// The postal code portion of an address.
        ///
        /// **If query is given, should not use this parameter.**
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<GeocodingResponse> GetGeocoding(int? top = null, string query = null, string addressLine = null, string countryRegion = null, IEnumerable<double> boundingBox = null, string view = null, IEnumerable<double> coordinates = null, string adminDistrict = null, string adminDistrict2 = null, string adminDistrict3 = null, string locality = null, string postalCode = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateGetGeocodingRequest(top, query, addressLine, countryRegion, boundingBox, view, coordinates, adminDistrict, adminDistrict2, adminDistrict3, locality, postalCode);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GeocodingResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = GeocodingResponse.DeserializeGeocodingResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetGeocodingBatchRequest(GeocodingBatchRequestBody geocodingBatchRequestBody)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/geocode:batch", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            if (_acceptLanguage != null)
            {
                request.Headers.Add("Accept-Language", _acceptLanguage);
            }
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Common.Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(geocodingBatchRequestBody);
            request.Content = content;
            return message;
        }

        /// <summary>
        /// **Geocoding Batch API**
        ///
        ///
        /// **Applies to:** see [pricing tiers](https://aka.ms/AzureMapsPricingTier).
        ///
        ///
        ///
        /// The Geocoding Batch API sends batches of queries to [Geocoding API](/rest/api/maps/search/get-geocoding) using just a single API call. The API allows caller to batch up to **100** queries.
        ///
        /// ### Submit Synchronous Batch Request
        /// The Synchronous API is recommended for lightweight batch requests. When the service receives a request, it will respond as soon as the batch items are calculated and there will be no possibility to retrieve the results later. The Synchronous API will return a timeout error (a 408 response) if the request takes longer than 60 seconds. The number of batch items is limited to **100** for this API.
        /// ```
        /// POST https://atlas.microsoft.com/geocode:batch?api-version=2023-06-01
        /// ```
        /// ### POST Body for Batch Request
        /// To send the _geocoding_ queries you will use a `POST` request where the request body will contain the `batchItems` array in `json` format and the `Content-Type` header will be set to `application/json`. Here's a sample request body containing 2 _geocoding_ queries:
        ///
        ///
        /// ```
        /// {
        ///   "batchItems": [
        ///     {
        ///       "addressLine": "One, Microsoft Way, Redmond, WA 98052",
        ///       "top": 2
        ///     },
        ///     {
        ///       "addressLine": "Pike Pl",
        ///       "adminDistrict": "WA",
        ///       "locality": "Seattle",
        ///       "top": 3
        ///     }
        ///   ]
        /// }
        /// ```
        ///
        /// A _geocoding_ batchItem object can accept any of the supported _geocoding_ [URI parameters](/rest/api/maps/search/get-geocoding#uri-parameters).
        ///
        ///
        /// The batch should contain at least **1** query.
        ///
        ///
        /// ### Batch Response Model
        /// The batch response contains a `summary` component that indicates the `totalRequests` that were part of the original batch request and `successfulRequests` i.e. queries which were executed successfully. The batch response also includes a `batchItems` array which contains a response for each and every query in the batch request. The `batchItems` will contain the results in the exact same order the original queries were sent in the batch request. Each item is of one of the following types:
        ///
        ///   - [`GeocodingResponse`](/rest/api/maps/search/get-geocoding#geocodingresponse) - If the query completed successfully.
        ///
        ///   - `Error` - If the query failed. The response will contain a `code` and a `message` in this case.
        ///
        ///
        ///
        /// </summary>
        /// <param name="geocodingBatchRequestBody"> The list of address geocoding queries/requests to process. The list can contain a max of 100 queries and must contain at least 1 query. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="geocodingBatchRequestBody"/> is null. </exception>
        public async Task<Response<GeocodingBatchResponse>> GetGeocodingBatchAsync(GeocodingBatchRequestBody geocodingBatchRequestBody, CancellationToken cancellationToken = default)
        {
            if (geocodingBatchRequestBody == null)
            {
                throw new ArgumentNullException(nameof(geocodingBatchRequestBody));
            }

            using var message = CreateGetGeocodingBatchRequest(geocodingBatchRequestBody);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GeocodingBatchResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = GeocodingBatchResponse.DeserializeGeocodingBatchResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// **Geocoding Batch API**
        ///
        ///
        /// **Applies to:** see [pricing tiers](https://aka.ms/AzureMapsPricingTier).
        ///
        ///
        ///
        /// The Geocoding Batch API sends batches of queries to [Geocoding API](/rest/api/maps/search/get-geocoding) using just a single API call. The API allows caller to batch up to **100** queries.
        ///
        /// ### Submit Synchronous Batch Request
        /// The Synchronous API is recommended for lightweight batch requests. When the service receives a request, it will respond as soon as the batch items are calculated and there will be no possibility to retrieve the results later. The Synchronous API will return a timeout error (a 408 response) if the request takes longer than 60 seconds. The number of batch items is limited to **100** for this API.
        /// ```
        /// POST https://atlas.microsoft.com/geocode:batch?api-version=2023-06-01
        /// ```
        /// ### POST Body for Batch Request
        /// To send the _geocoding_ queries you will use a `POST` request where the request body will contain the `batchItems` array in `json` format and the `Content-Type` header will be set to `application/json`. Here's a sample request body containing 2 _geocoding_ queries:
        ///
        ///
        /// ```
        /// {
        ///   "batchItems": [
        ///     {
        ///       "addressLine": "One, Microsoft Way, Redmond, WA 98052",
        ///       "top": 2
        ///     },
        ///     {
        ///       "addressLine": "Pike Pl",
        ///       "adminDistrict": "WA",
        ///       "locality": "Seattle",
        ///       "top": 3
        ///     }
        ///   ]
        /// }
        /// ```
        ///
        /// A _geocoding_ batchItem object can accept any of the supported _geocoding_ [URI parameters](/rest/api/maps/search/get-geocoding#uri-parameters).
        ///
        ///
        /// The batch should contain at least **1** query.
        ///
        ///
        /// ### Batch Response Model
        /// The batch response contains a `summary` component that indicates the `totalRequests` that were part of the original batch request and `successfulRequests` i.e. queries which were executed successfully. The batch response also includes a `batchItems` array which contains a response for each and every query in the batch request. The `batchItems` will contain the results in the exact same order the original queries were sent in the batch request. Each item is of one of the following types:
        ///
        ///   - [`GeocodingResponse`](/rest/api/maps/search/get-geocoding#geocodingresponse) - If the query completed successfully.
        ///
        ///   - `Error` - If the query failed. The response will contain a `code` and a `message` in this case.
        ///
        ///
        ///
        /// </summary>
        /// <param name="geocodingBatchRequestBody"> The list of address geocoding queries/requests to process. The list can contain a max of 100 queries and must contain at least 1 query. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="geocodingBatchRequestBody"/> is null. </exception>
        public Response<GeocodingBatchResponse> GetGeocodingBatch(GeocodingBatchRequestBody geocodingBatchRequestBody, CancellationToken cancellationToken = default)
        {
            if (geocodingBatchRequestBody == null)
            {
                throw new ArgumentNullException(nameof(geocodingBatchRequestBody));
            }

            using var message = CreateGetGeocodingBatchRequest(geocodingBatchRequestBody);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GeocodingBatchResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = GeocodingBatchResponse.DeserializeGeocodingBatchResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetPolygonRequest(IEnumerable<double> coordinates, string view, BoundaryResultTypeEnum? resultType, ResolutionEnum? resolution)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/search/polygon", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (coordinates != null && !(coordinates is Common.ChangeTrackingList<double> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("coordinates", coordinates, ",", true);
            }
            if (view != null)
            {
                uri.AppendQuery("view", view, true);
            }
            if (resultType != null)
            {
                uri.AppendQuery("resultType", resultType.Value.ToString(), true);
            }
            if (resolution != null)
            {
                uri.AppendQuery("resolution", resolution.Value.ToString(), true);
            }
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            if (_acceptLanguage != null)
            {
                request.Headers.Add("Accept-Language", _acceptLanguage);
            }
            request.Headers.Add("Accept", "application/geo+json, application/json");
            return message;
        }

        /// <summary>
        /// **Get Polygon**
        ///
        /// **Applies to:** see [pricing tiers](https://aka.ms/AzureMapsPricingTier).
        ///
        /// Supplies polygon data of a geographical area outline such as a city or a country region.
        /// </summary>
        /// <param name="coordinates"> A point on the earth specified as a longitude and latitude. Example: &amp;coordinates=lon,lat. </param>
        /// <param name="view">
        /// A string that represents an [ISO 3166-1 Alpha-2 region/country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). This will alter Geopolitical disputed borders and labels to align with the specified user region. By default, the View parameter is set to “Auto” even if you haven’t defined it in the request.
        ///
        /// Please refer to [Supported Views](https://aka.ms/AzureMapsLocalizationViews) for details and to see the available Views.
        /// </param>
        /// <param name="resultType"> The geopolitical concept to return a boundary for. </param>
        /// <param name="resolution"> Resolution determines the amount of points to send back. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="coordinates"/> is null. </exception>
        public async Task<Response<BoundaryInternal>> GetPolygonAsync(IEnumerable<double> coordinates, string view = null, BoundaryResultTypeEnum? resultType = null, ResolutionEnum? resolution = null, CancellationToken cancellationToken = default)
        {
            if (coordinates == null)
            {
                throw new ArgumentNullException(nameof(coordinates));
            }

            using var message = CreateGetPolygonRequest(coordinates, view, resultType, resolution);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        BoundaryInternal value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = BoundaryInternal.DeserializeBoundaryInternal(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// **Get Polygon**
        ///
        /// **Applies to:** see [pricing tiers](https://aka.ms/AzureMapsPricingTier).
        ///
        /// Supplies polygon data of a geographical area outline such as a city or a country region.
        /// </summary>
        /// <param name="coordinates"> A point on the earth specified as a longitude and latitude. Example: &amp;coordinates=lon,lat. </param>
        /// <param name="view">
        /// A string that represents an [ISO 3166-1 Alpha-2 region/country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). This will alter Geopolitical disputed borders and labels to align with the specified user region. By default, the View parameter is set to “Auto” even if you haven’t defined it in the request.
        ///
        /// Please refer to [Supported Views](https://aka.ms/AzureMapsLocalizationViews) for details and to see the available Views.
        /// </param>
        /// <param name="resultType"> The geopolitical concept to return a boundary for. </param>
        /// <param name="resolution"> Resolution determines the amount of points to send back. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="coordinates"/> is null. </exception>
        public Response<BoundaryInternal> GetPolygon(IEnumerable<double> coordinates, string view = null, BoundaryResultTypeEnum? resultType = null, ResolutionEnum? resolution = null, CancellationToken cancellationToken = default)
        {
            if (coordinates == null)
            {
                throw new ArgumentNullException(nameof(coordinates));
            }

            using var message = CreateGetPolygonRequest(coordinates, view, resultType, resolution);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        BoundaryInternal value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = BoundaryInternal.DeserializeBoundaryInternal(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetReverseGeocodingRequest(IEnumerable<double> coordinates, IEnumerable<ReverseGeocodingResultTypeEnum> resultTypes, string view)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/reverseGeocode", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (coordinates != null && !(coordinates is Common.ChangeTrackingList<double> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("coordinates", coordinates, ",", true);
            }
            if (resultTypes != null && !(resultTypes is Common.ChangeTrackingList<ReverseGeocodingResultTypeEnum> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                uri.AppendQueryDelimited("resultTypes", resultTypes, ",", true);
            }
            if (view != null)
            {
                uri.AppendQuery("view", view, true);
            }
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            if (_acceptLanguage != null)
            {
                request.Headers.Add("Accept-Language", _acceptLanguage);
            }
            request.Headers.Add("Accept", "application/geo+json, application/json");
            return message;
        }

        /// <summary>
        /// **Reverse Geocoding**
        ///
        /// **Applies to:** see [pricing tiers](https://aka.ms/AzureMapsPricingTier).
        ///
        /// Translate a coordinate (example: 37.786505, -122.3862) into a human understandable street address. Most often this is needed in tracking applications where you receive a GPS feed from the device or asset and wish to know what address where the coordinate is located. This endpoint will return address information for a given coordinate.
        /// </summary>
        /// <param name="coordinates"> The coordinates of the location that you want to reverse geocode. Example: &amp;coordinates=lon,lat. </param>
        /// <param name="resultTypes">
        /// Specify entity types that you want in the response. Only the types you specify will be returned. If the point cannot be mapped to the entity types you specify, no location information is returned in the response.
        /// Default value is all possible entities.
        /// A comma separated list of entity types selected from the following options.
        ///
        /// - Address
        /// - Neighborhood
        /// - PopulatedPlace
        /// - Postcode1
        /// - AdminDivision1
        /// - AdminDivision2
        /// - CountryRegion
        ///
        /// These entity types are ordered from the most specific entity to the least specific entity. When entities of more than one entity type are found, only the most specific entity is returned. For example, if you specify Address and AdminDistrict1 as entity types and entities were found for both types, only the Address entity information is returned in the response.
        /// </param>
        /// <param name="view">
        /// A string that represents an [ISO 3166-1 Alpha-2 region/country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). This will alter Geopolitical disputed borders and labels to align with the specified user region. By default, the View parameter is set to “Auto” even if you haven’t defined it in the request.
        ///
        /// Please refer to [Supported Views](https://aka.ms/AzureMapsLocalizationViews) for details and to see the available Views.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="coordinates"/> is null. </exception>
        public async Task<Response<GeocodingResponse>> GetReverseGeocodingAsync(IEnumerable<double> coordinates, IEnumerable<ReverseGeocodingResultTypeEnum> resultTypes = null, string view = null, CancellationToken cancellationToken = default)
        {
            if (coordinates == null)
            {
                throw new ArgumentNullException(nameof(coordinates));
            }

            using var message = CreateGetReverseGeocodingRequest(coordinates, resultTypes, view);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GeocodingResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = GeocodingResponse.DeserializeGeocodingResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// **Reverse Geocoding**
        ///
        /// **Applies to:** see [pricing tiers](https://aka.ms/AzureMapsPricingTier).
        ///
        /// Translate a coordinate (example: 37.786505, -122.3862) into a human understandable street address. Most often this is needed in tracking applications where you receive a GPS feed from the device or asset and wish to know what address where the coordinate is located. This endpoint will return address information for a given coordinate.
        /// </summary>
        /// <param name="coordinates"> The coordinates of the location that you want to reverse geocode. Example: &amp;coordinates=lon,lat. </param>
        /// <param name="resultTypes">
        /// Specify entity types that you want in the response. Only the types you specify will be returned. If the point cannot be mapped to the entity types you specify, no location information is returned in the response.
        /// Default value is all possible entities.
        /// A comma separated list of entity types selected from the following options.
        ///
        /// - Address
        /// - Neighborhood
        /// - PopulatedPlace
        /// - Postcode1
        /// - AdminDivision1
        /// - AdminDivision2
        /// - CountryRegion
        ///
        /// These entity types are ordered from the most specific entity to the least specific entity. When entities of more than one entity type are found, only the most specific entity is returned. For example, if you specify Address and AdminDistrict1 as entity types and entities were found for both types, only the Address entity information is returned in the response.
        /// </param>
        /// <param name="view">
        /// A string that represents an [ISO 3166-1 Alpha-2 region/country code](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2). This will alter Geopolitical disputed borders and labels to align with the specified user region. By default, the View parameter is set to “Auto” even if you haven’t defined it in the request.
        ///
        /// Please refer to [Supported Views](https://aka.ms/AzureMapsLocalizationViews) for details and to see the available Views.
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="coordinates"/> is null. </exception>
        public Response<GeocodingResponse> GetReverseGeocoding(IEnumerable<double> coordinates, IEnumerable<ReverseGeocodingResultTypeEnum> resultTypes = null, string view = null, CancellationToken cancellationToken = default)
        {
            if (coordinates == null)
            {
                throw new ArgumentNullException(nameof(coordinates));
            }

            using var message = CreateGetReverseGeocodingRequest(coordinates, resultTypes, view);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GeocodingResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = GeocodingResponse.DeserializeGeocodingResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal HttpMessage CreateGetReverseGeocodingBatchRequest(ReverseGeocodingBatchRequestBody reverseGeocodingBatchRequestBody)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/reverseGeocode:batch", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            if (_clientId != null)
            {
                request.Headers.Add("x-ms-client-id", _clientId);
            }
            if (_acceptLanguage != null)
            {
                request.Headers.Add("Accept-Language", _acceptLanguage);
            }
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Common.Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(reverseGeocodingBatchRequestBody);
            request.Content = content;
            return message;
        }

        /// <summary>
        /// **Reverse Geocoding Batch API**
        ///
        ///
        /// **Applies to:** see [pricing tiers](https://aka.ms/AzureMapsPricingTier).
        ///
        ///
        ///
        /// The Reverse Geocoding Batch API sends batches of queries to [Reverse Geocoding API](/rest/api/maps/search/get-reverse-geocoding) using just a single API call. The API allows caller to batch up to **100** queries.
        ///
        /// ### Submit Synchronous Batch Request
        /// The Synchronous API is recommended for lightweight batch requests. When the service receives a request, it will respond as soon as the batch items are calculated and there will be no possibility to retrieve the results later. The Synchronous API will return a timeout error (a 408 response) if the request takes longer than 60 seconds. The number of batch items is limited to **100** for this API.
        /// ```
        /// POST https://atlas.microsoft.com/reverseGeocode:batch?api-version=2023-06-01
        /// ```
        /// ### POST Body for Batch Request
        /// To send the _reverse geocoding_ queries you will use a `POST` request where the request body will contain the `batchItems` array in `json` format and the `Content-Type` header will be set to `application/json`. Here's a sample request body containing 2 _reverse geocoding_ queries:
        ///
        ///
        /// ```
        /// {
        ///   "batchItems": [
        ///     {
        ///       "coordinates": [-122.128275, 47.639429],
        ///       "resultTypes": ["Address", "PopulatedPlace"]
        ///     },
        ///     {
        ///       "coordinates": [-122.341979399674, 47.6095253501216]
        ///     }
        ///   ]
        /// }
        /// ```
        ///
        /// A _reverse geocoding_ batchItem object can accept any of the supported _reverse geocoding_ [URI parameters](/rest/api/maps/search/get-reverse-geocoding#uri-parameters).
        ///
        ///
        /// The batch should contain at least **1** query.
        ///
        ///
        /// ### Batch Response Model
        /// The batch response contains a `summary` component that indicates the `totalRequests` that were part of the original batch request and `successfulRequests` i.e. queries which were executed successfully. The batch response also includes a `batchItems` array which contains a response for each and every query in the batch request. The `batchItems` will contain the results in the exact same order the original queries were sent in the batch request. Each item is of one of the following types:
        ///
        ///   - [`GeocodingResponse`](/rest/api/maps/search/get-reverse-geocoding#geocodingresponse) - If the query completed successfully.
        ///
        ///   - `Error` - If the query failed. The response will contain a `code` and a `message` in this case.
        ///
        ///
        ///
        /// </summary>
        /// <param name="reverseGeocodingBatchRequestBody"> The list of reverse geocoding queries/requests to process. The list can contain a max of 100 queries and must contain at least 1 query. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="reverseGeocodingBatchRequestBody"/> is null. </exception>
        public async Task<Response<GeocodingBatchResponse>> GetReverseGeocodingBatchAsync(ReverseGeocodingBatchRequestBody reverseGeocodingBatchRequestBody, CancellationToken cancellationToken = default)
        {
            if (reverseGeocodingBatchRequestBody == null)
            {
                throw new ArgumentNullException(nameof(reverseGeocodingBatchRequestBody));
            }

            using var message = CreateGetReverseGeocodingBatchRequest(reverseGeocodingBatchRequestBody);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GeocodingBatchResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = GeocodingBatchResponse.DeserializeGeocodingBatchResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary>
        /// **Reverse Geocoding Batch API**
        ///
        ///
        /// **Applies to:** see [pricing tiers](https://aka.ms/AzureMapsPricingTier).
        ///
        ///
        ///
        /// The Reverse Geocoding Batch API sends batches of queries to [Reverse Geocoding API](/rest/api/maps/search/get-reverse-geocoding) using just a single API call. The API allows caller to batch up to **100** queries.
        ///
        /// ### Submit Synchronous Batch Request
        /// The Synchronous API is recommended for lightweight batch requests. When the service receives a request, it will respond as soon as the batch items are calculated and there will be no possibility to retrieve the results later. The Synchronous API will return a timeout error (a 408 response) if the request takes longer than 60 seconds. The number of batch items is limited to **100** for this API.
        /// ```
        /// POST https://atlas.microsoft.com/reverseGeocode:batch?api-version=2023-06-01
        /// ```
        /// ### POST Body for Batch Request
        /// To send the _reverse geocoding_ queries you will use a `POST` request where the request body will contain the `batchItems` array in `json` format and the `Content-Type` header will be set to `application/json`. Here's a sample request body containing 2 _reverse geocoding_ queries:
        ///
        ///
        /// ```
        /// {
        ///   "batchItems": [
        ///     {
        ///       "coordinates": [-122.128275, 47.639429],
        ///       "resultTypes": ["Address", "PopulatedPlace"]
        ///     },
        ///     {
        ///       "coordinates": [-122.341979399674, 47.6095253501216]
        ///     }
        ///   ]
        /// }
        /// ```
        ///
        /// A _reverse geocoding_ batchItem object can accept any of the supported _reverse geocoding_ [URI parameters](/rest/api/maps/search/get-reverse-geocoding#uri-parameters).
        ///
        ///
        /// The batch should contain at least **1** query.
        ///
        ///
        /// ### Batch Response Model
        /// The batch response contains a `summary` component that indicates the `totalRequests` that were part of the original batch request and `successfulRequests` i.e. queries which were executed successfully. The batch response also includes a `batchItems` array which contains a response for each and every query in the batch request. The `batchItems` will contain the results in the exact same order the original queries were sent in the batch request. Each item is of one of the following types:
        ///
        ///   - [`GeocodingResponse`](/rest/api/maps/search/get-reverse-geocoding#geocodingresponse) - If the query completed successfully.
        ///
        ///   - `Error` - If the query failed. The response will contain a `code` and a `message` in this case.
        ///
        ///
        ///
        /// </summary>
        /// <param name="reverseGeocodingBatchRequestBody"> The list of reverse geocoding queries/requests to process. The list can contain a max of 100 queries and must contain at least 1 query. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="reverseGeocodingBatchRequestBody"/> is null. </exception>
        public Response<GeocodingBatchResponse> GetReverseGeocodingBatch(ReverseGeocodingBatchRequestBody reverseGeocodingBatchRequestBody, CancellationToken cancellationToken = default)
        {
            if (reverseGeocodingBatchRequestBody == null)
            {
                throw new ArgumentNullException(nameof(reverseGeocodingBatchRequestBody));
            }

            using var message = CreateGetReverseGeocodingBatchRequest(reverseGeocodingBatchRequestBody);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        GeocodingBatchResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = GeocodingBatchResponse.DeserializeGeocodingBatchResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
