// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Search.Models
{
    /// <summary> The ReverseGeocodingResultTypeEnum. </summary>
    public readonly partial struct ReverseGeocodingResultTypeEnum : IEquatable<ReverseGeocodingResultTypeEnum>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReverseGeocodingResultTypeEnum"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReverseGeocodingResultTypeEnum(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AddressValue = "Address";
        private const string NeighborhoodValue = "Neighborhood";
        private const string PopulatedPlaceValue = "PopulatedPlace";
        private const string Postcode1Value = "Postcode1";
        private const string AdminDivision1Value = "AdminDivision1";
        private const string AdminDivision2Value = "AdminDivision2";
        private const string CountryRegionValue = "CountryRegion";

        /// <summary> Address. </summary>
        public static ReverseGeocodingResultTypeEnum Address { get; } = new ReverseGeocodingResultTypeEnum(AddressValue);
        /// <summary> Neighborhood. </summary>
        public static ReverseGeocodingResultTypeEnum Neighborhood { get; } = new ReverseGeocodingResultTypeEnum(NeighborhoodValue);
        /// <summary> PopulatedPlace. </summary>
        public static ReverseGeocodingResultTypeEnum PopulatedPlace { get; } = new ReverseGeocodingResultTypeEnum(PopulatedPlaceValue);
        /// <summary> Postcode1. </summary>
        public static ReverseGeocodingResultTypeEnum Postcode1 { get; } = new ReverseGeocodingResultTypeEnum(Postcode1Value);
        /// <summary> AdminDivision1. </summary>
        public static ReverseGeocodingResultTypeEnum AdminDivision1 { get; } = new ReverseGeocodingResultTypeEnum(AdminDivision1Value);
        /// <summary> AdminDivision2. </summary>
        public static ReverseGeocodingResultTypeEnum AdminDivision2 { get; } = new ReverseGeocodingResultTypeEnum(AdminDivision2Value);
        /// <summary> CountryRegion. </summary>
        public static ReverseGeocodingResultTypeEnum CountryRegion { get; } = new ReverseGeocodingResultTypeEnum(CountryRegionValue);
        /// <summary> Determines if two <see cref="ReverseGeocodingResultTypeEnum"/> values are the same. </summary>
        public static bool operator ==(ReverseGeocodingResultTypeEnum left, ReverseGeocodingResultTypeEnum right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReverseGeocodingResultTypeEnum"/> values are not the same. </summary>
        public static bool operator !=(ReverseGeocodingResultTypeEnum left, ReverseGeocodingResultTypeEnum right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReverseGeocodingResultTypeEnum"/>. </summary>
        public static implicit operator ReverseGeocodingResultTypeEnum(string value) => new ReverseGeocodingResultTypeEnum(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReverseGeocodingResultTypeEnum other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReverseGeocodingResultTypeEnum other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
