// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using Azure.Core;
using Azure.Maps.Common;

namespace Azure.Maps.Search.Models
{
    public partial class ReverseGeocodingBatchRequestItem : IUtf8JsonSerializable
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer)
        {
            writer.WriteStartObject();
            if (Common.Optional.IsDefined(OptionalId))
            {
                writer.WritePropertyName("optionalId"u8);
                writer.WriteStringValue(OptionalId);
            }
            if (Common.Optional.IsCollectionDefined(_Coordinates))
            {
                writer.WritePropertyName("coordinates"u8);
                writer.WriteStartArray();
                foreach (var item in _Coordinates)
                {
                    writer.WriteNumberValue(item);
                }
                writer.WriteEndArray();
            }
            if (Common.Optional.IsCollectionDefined(ResultTypes))
            {
                writer.WritePropertyName("resultTypes"u8);
                writer.WriteStartArray();
                foreach (var item in ResultTypes)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (Common.Optional.IsDefined(View))
            {
                writer.WritePropertyName("view"u8);
                writer.WriteStringValue(View);
            }
            writer.WritePropertyName("coordinates"u8);
            SerializeCoordinatesValue(writer);
            writer.WriteEndObject();
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Common.Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this);
            return content;
        }
    }
}
