// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Search.Models
{
    /// <summary> The ResolutionEnum. </summary>
    public readonly partial struct ResolutionEnum : IEquatable<ResolutionEnum>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ResolutionEnum"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ResolutionEnum(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SmallValue = "small";
        private const string MediumValue = "medium";
        private const string LargeValue = "large";
        private const string HugeValue = "huge";

        /// <summary> Return the boundary geometry with the least amount of points. </summary>
        public static ResolutionEnum Small { get; } = new ResolutionEnum(SmallValue);
        /// <summary> Return the boundary geometry with more or the same amount of points as small. </summary>
        public static ResolutionEnum Medium { get; } = new ResolutionEnum(MediumValue);
        /// <summary> Return the boundary geometry with more or the same amount of points as medium. </summary>
        public static ResolutionEnum Large { get; } = new ResolutionEnum(LargeValue);
        /// <summary> Return the boundary geometry with more or the same amount of points as large. </summary>
        public static ResolutionEnum Huge { get; } = new ResolutionEnum(HugeValue);
        /// <summary> Determines if two <see cref="ResolutionEnum"/> values are the same. </summary>
        public static bool operator ==(ResolutionEnum left, ResolutionEnum right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ResolutionEnum"/> values are not the same. </summary>
        public static bool operator !=(ResolutionEnum left, ResolutionEnum right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ResolutionEnum"/>. </summary>
        public static implicit operator ResolutionEnum(string value) => new ResolutionEnum(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ResolutionEnum other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ResolutionEnum other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
