// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Maps.Search.Models
{
    /// <summary> The MatchCodesEnum. </summary>
    public readonly partial struct MatchCodesEnum : IEquatable<MatchCodesEnum>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MatchCodesEnum"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MatchCodesEnum(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GoodValue = "Good";
        private const string AmbiguousValue = "Ambiguous";
        private const string UpHierarchyValue = "UpHierarchy";

        /// <summary> Good. </summary>
        public static MatchCodesEnum Good { get; } = new MatchCodesEnum(GoodValue);
        /// <summary> Ambiguous. </summary>
        public static MatchCodesEnum Ambiguous { get; } = new MatchCodesEnum(AmbiguousValue);
        /// <summary> UpHierarchy. </summary>
        public static MatchCodesEnum UpHierarchy { get; } = new MatchCodesEnum(UpHierarchyValue);
        /// <summary> Determines if two <see cref="MatchCodesEnum"/> values are the same. </summary>
        public static bool operator ==(MatchCodesEnum left, MatchCodesEnum right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MatchCodesEnum"/> values are not the same. </summary>
        public static bool operator !=(MatchCodesEnum left, MatchCodesEnum right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MatchCodesEnum"/>. </summary>
        public static implicit operator MatchCodesEnum(string value) => new MatchCodesEnum(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MatchCodesEnum other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MatchCodesEnum other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
