// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;

namespace Azure.Maps.Search.Models
{
    public partial class Intersection
    {
        internal static Intersection DeserializeIntersection(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string baseStreet = default;
            string secondaryStreet1 = default;
            string secondaryStreet2 = default;
            string intersectionType = default;
            string displayName = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("baseStreet"u8))
                {
                    baseStreet = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("secondaryStreet1"u8))
                {
                    secondaryStreet1 = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("secondaryStreet2"u8))
                {
                    secondaryStreet2 = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("intersectionType"u8))
                {
                    intersectionType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("displayName"u8))
                {
                    displayName = property.Value.GetString();
                    continue;
                }
            }
            return new Intersection(baseStreet, secondaryStreet1, secondaryStreet2, intersectionType, displayName);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static Intersection FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeIntersection(document.RootElement);
        }
    }
}
