// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using Azure.Maps.Common;

namespace Azure.Maps.Search.Models
{
    /// <summary> This object is returned from a successful Geocoding call. </summary>
    public partial class GeocodingResponse
    {
        /// <summary> Initializes a new instance of <see cref="GeocodingResponse"/>. </summary>
        internal GeocodingResponse()
        {
            Features = new ChangeTrackingList<FeaturesItem>();
        }

        /// <summary> Initializes a new instance of <see cref="GeocodingResponse"/>. </summary>
        /// <param name="type"> The type of a FeatureCollection object must be FeatureCollection. </param>
        /// <param name="features"></param>
        /// <param name="nextLink"> The is the link to the next page of the features returned. If it's the last page, no this field. </param>
        internal GeocodingResponse(FeatureCollectionEnum? type, IReadOnlyList<FeaturesItem> features, string nextLink)
        {
            Type = type;
            Features = features;
            NextLink = nextLink;
        }

        /// <summary> The type of a FeatureCollection object must be FeatureCollection. </summary>
        public FeatureCollectionEnum? Type { get; }
        /// <summary> Gets the features. </summary>
        public IReadOnlyList<FeaturesItem> Features { get; }
        /// <summary> The is the link to the next page of the features returned. If it's the last page, no this field. </summary>
        public string NextLink { get; }
    }
}
