// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;
using Azure.Maps.Common;

namespace Azure.Maps.Search.Models
{
    public partial class GeocodingResponse
    {
        internal static GeocodingResponse DeserializeGeocodingResponse(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            FeatureCollectionEnum? type = default;
            IReadOnlyList<FeaturesItem> features = default;
            string nextLink = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("type"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    type = new FeatureCollectionEnum(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("features"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<FeaturesItem> array = new List<FeaturesItem>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(FeaturesItem.DeserializeFeaturesItem(item));
                    }
                    features = array;
                    continue;
                }
                if (property.NameEquals("nextLink"u8))
                {
                    nextLink = property.Value.GetString();
                    continue;
                }
            }
            return new GeocodingResponse(type, features ?? new ChangeTrackingList<FeaturesItem>(), nextLink);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static GeocodingResponse FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeGeocodingResponse(document.RootElement);
        }
    }
}
